﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <binary/WavFormat.h>

namespace nw {
namespace snd {

//---------------------------------------------------------------------------
//! @brief  WAVE フォーマット情報を格納します。
//---------------------------------------------------------------------------
typedef struct WaveFormat
{
    static const u16 FORMAT_PCM = FmtChunk::FORMAT_PCM;

    //---------------------------------------------------------------------------

    /* ctor */ WaveFormat() :
        formatTag(FORMAT_PCM),
        channels(0),
        samplesPerSec(0),
        avgBytesPerSec(0),
        blockAlign(0),
        bitsPerSample(0)
    { }

    //---------------------------------------------------------------------------

    u16 formatTag;
    u16 channels;
    u32 samplesPerSec;
    u32 avgBytesPerSec;
    u16 blockAlign;
    u16 bitsPerSample;
} WaveFormat;

} // snd
} // nw
