﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SOUNDPLAYER_HIO_MANAGER_H_
#define NW_SOUNDPLAYER_HIO_MANAGER_H_

#include <nw/ut.h>
#include <mcs/HioChannel.h>

namespace nw {
namespace snd {

//---------------------------------------------------------------------------
//! @brief    HIO管理クラスです。
//!
//! @details  HIOの初期化やHIOチャンネルの管理、更新を行います。
//---------------------------------------------------------------------------
class HioManager
{
private:
    typedef nw::ut::LinkList<HioChannel::Reference, offsetof(HioChannel::Reference, node)> HioChannelRefList;

public:
    /* ctor */ HioManager();
    /* dtor */ ~HioManager();

public:
    //! @brief  初期化します。
    bool Initialize();

    //! @brief  終了処理を行います。
    void Finalize();

    //! @brief  初期化の有無を取得します。
    bool IsInitialized() const { return m_IsInitialized; }

    //! @brief  チャンネルを登録します。
    void RegisterChannel(HioChannel& channel);

    //! @brief  チャンネルの登録を解除します。
    void UnregisterChannel(HioChannel& channel);

    //! @brief  更新します。
    void Update();

private:
    //! @brief  すべてのチャンネルを更新します。
    void UpdateChannels();

private:
    bool m_IsInitialized;               //!< 初期化フラグです。
    HioChannelRefList m_ChannelRefs;    //!< HIOチャンネル参照リストです。
};

} // namespace nw::snd
} // namespace nw

#endif // NW_SOUNDPLAYER_HIO_MANAGER_H_

