﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut.h>

namespace nw {
namespace snd {

template<class TValue, u32 Alignment>
class AlignedObject
{
public:
    AlignedObject()
    {
        if(Alignment == 0)
        {
            m_pValue = new(m_Buffer) TValue();
        }
        else
        {
            m_pValue = new(nw::ut::RoundUp(m_Buffer, Alignment)) TValue();
        }

        NW_NULL_ASSERT(m_pValue);
    }

    ~AlignedObject()
    {
        m_pValue->~TValue();
        delete(nw::ut::RoundUp(m_Buffer, Alignment));
    }

public:
    TValue& GetValue()
    {
        return *m_pValue;
    }

    operator TValue&()
    {
        return *m_pValue;
    }

private:
    TValue* m_pValue;
    u8 m_Buffer[sizeof(TValue) + Alignment];
};

} // snd
} // nw
