﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedListBox.h>
#include <controls/ParameterListItem.h>

namespace nw {
namespace snd {

template<class TModel, u32 MaxItemCount>
class ParameterListView : public nw::internal::dw::UIElement
{
private:
    static const f32 INVALID_WIDTH;

public:
    ParameterListView();

public:
    void SetModel(TModel* pModel);
    void SetLabelWidth(f32 width);

protected:
    void AddItem(ModelParameterListItem<TModel>& item);

private:
    void UpdateModels();

private:
    TModel* m_pModel;
    f32 m_LabelWidth;

    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedListBox<MaxItemCount> m_Container;

    ModelParameterListItem<TModel>* m_ListItems[MaxItemCount];

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "ParameterListView";
    }
#endif
};

} // snd
} // nw

#include "ParameterListView.hpp"
