﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedLabel.h>
#include <nw/dw/control/dw_FixedUIElementList.h>

namespace nw {
namespace snd {

class Lamp : public nw::internal::dw::UIElement
{
private:
    typedef nw::internal::dw::UIElement Base;

public:
    Lamp();

public:
    const char* GetLabelText() const;
    void SetLabelText(const char* pText);

    bool GetIsLamped() const;
    void SetIsLamped(bool value);

    nw::ut::Color4f GetLampedBackgroundColor() const;
    void SetLampedBackgroundColor(nw::ut::Color4f value);

    nw::ut::Color4f GetLampedBorderColor() const;
    void SetLampedBorderColor(nw::ut::Color4f value);

    nw::ut::Color4f GetLampedTextColor() const;
    void SetLampedTextColor(nw::ut::Color4f value);

    nw::ut::Color4f GetTextColor() const;
    void SetTextColor(nw::ut::Color4f value);

protected:
    /*override*/ const nw::math::Vector2 OnMeasure(nw::internal::dw::UIRenderer& renderer) const;

    //---------------------------------------------------------------------------
    //! @brief       UI要素描画の準備を行います。
    //!
    //! @details     UI要素描画の準備を行います。
    //!              特別な更新処理を行う場合は、この関数をオーバーライドしてください。
    //!
    //! @param[in]   context  UIElementTreeContext を指定します。
    //!
    //! @return      描画に使用するパラメータへの参照を返します。
    //---------------------------------------------------------------------------
    /*override*/ nw::internal::dw::UIElementRenderArgs& OnPrepareRender(const nw::internal::dw::UIElementTreeContext& context);

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedLabel<32> m_Label;

    bool m_isLamped;
    nw::ut::Color4f m_LampedBackgroundColor;
    nw::ut::Color4f m_LampedBorderColor;
    nw::ut::Color4f m_LampedTextColor;
    nw::ut::Color4f m_TextColor;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "Lamp";
    }
#endif
};

} // snd
} // nw
