﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <controls/ParameterListItem.h>

namespace nw {
namespace snd {

template<class TModel>
class F32ParameterListItem : public ModelParameterListItem<TModel>
{
private:
    typedef ModelParameterListItem<TModel> Base;

public:
    typedef f32  (*GetValueHandler)(TModel* pPreviewSound);
    typedef void (*SetValueHandler)(TModel* pPreviewSound, f32 value);
    typedef void (*PrintValueHandler)(char* pText, u32 bufferLength, f32 value);

public:
    F32ParameterListItem();
    virtual ~F32ParameterListItem() { }

public:
    void Initialize(
        GetValueHandler pGetValueHandler,
        SetValueHandler pSetValueHandler,
        PrintValueHandler pPrintValueHandler);

    void Initialize(
        GetIsCheckedHandler pGetIsCheckedHandler,
        SetIsCheckedHandler pSetIsCheckedHandler,
        GetValueHandler pGetValueHandler,
        SetValueHandler pSetValueHandler,
        PrintValueHandler pPrintValueHandler);

    f32 GetValue() const;
    void SetValue(f32 value);

    f32 GetDefaultValue() const;
    void SetDefaultValue(f32 value);

    f32 GetValueChange() const;
    void SetValueChange(f32 value);

    f32 GetValueLargeChange() const;
    void SetValueLargeChange(f32 value);

    f32 GetMinimumValue() const;
    void SetMinimumValue(f32 value);

    f32 GetMaximumValue() const;
    void SetMaximumValue(f32 value);

    /*override*/ void ResetValue();

protected:
    /*override*/ void NextValue(bool isLargeChange);
    /*override*/ void PreviousValue(bool isLargeChange);
    /*override*/ void PrintValue(char* pText, u32 bufferLength);

private:
    f32 m_DefaultValue;
    f32 m_ValueChange;
    f32 m_ValueLargeChange;
    f32 m_MinimumValue;
    f32 m_MaximumValue;

    GetValueHandler m_pGetValueHandler;
    SetValueHandler m_pSetValueHandler;
    PrintValueHandler m_pPrintValueHandler;

#if defined(NW_DEBUG)

public:
    virtual const char* ToString() const
    {
        return "F32ParameterListItem";
    }

#endif
};

} // snd
} // nw

#include "F32ParameterListItem.hpp"
