﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Drawing;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NintendoWare.SoundMaker
{
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.Windows;
    using NintendoWare.SoundMaker.Resources;
    using NintendoWare.SoundMakerPlugin;

    public class TargetPlayerNX : ITargetPlayer
    {
        private string atkPlayerFilePath = string.Empty;
        private string shutdownAtkPlayerFilePath = string.Empty;

        public TargetPlayerNX(string atkPlayerFilePath, string shutdownAtkPlayerFilePath)
        {
            this.atkPlayerFilePath = atkPlayerFilePath;
            this.shutdownAtkPlayerFilePath = shutdownAtkPlayerFilePath;
        }

        void ITargetPlayer.Run(TargetPlayerRunArgument args)
        {
            Preview.AtkPlayerNX.Start(this.atkPlayerFilePath, args.SoundArchivePath);
        }

        void ITargetPlayer.Shutdown()
        {
            Preview.AtkPlayerNX.Stop(this.shutdownAtkPlayerFilePath);
        }

        string ITargetPlayer.UIRunMenuText
        {
            get
            {
                return MessageResource.Command_Preview_RunTargetAtkPlayer_MenuText;
            }
        }

        string ITargetPlayer.UIRunButtonText
        {
            get
            {
                return MessageResource.Command_Preview_RunTargetAtkPlayer_ButtonText;
            }
        }

        string ITargetPlayer.UIRunToolTipText
        {
            get
            {
                return MessageResource.Command_Preview_RunTargetAtkPlayer_ToolTipText;
            }
        }

        Image ITargetPlayer.UIRunIconImage
        {
            get
            {
                return ImageResource.BitmapIconRunTargetAtkPlayer.MakeNewTransparent(UIServiceBase.TransparentColor);
            }
        }

        string ITargetPlayer.UIConfirmRunTitle
        {
            get
            {
                return MessageResource.ConfirmRunTargetAtkPlayerTitle;
            }
        }

        string ITargetPlayer.UIConfirmRunMessage
        {
            get
            {
                return MessageResource.ConfirmRunTargetAtkPlayer;
            }
        }

        string ITargetPlayer.UIShutdownMenuText
        {
            get
            {
                return MessageResource.Command_Preview_ShutdownTargetAtkPlayer_Text;
            }
        }
    }
}
