﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
// MEFを使うには以下の2つが必要です。
// 参照設定にもSystem.ComponentModel.Compositionを追加する必要があります。
using System.ComponentModel.Composition;
using System.Configuration;
using System.IO;
using System.Linq;
using System.Reflection;

namespace NintendoWare.SoundMaker
{
    using NintendoWare.SoundFoundation.Conversion;
    using NintendoWare.SoundFoundation.Conversion.NintendoWareBinary;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.FileFormats;
    using NintendoWare.SoundMaker.Preview.Communications;
    using NintendoWare.SoundMaker.Resources;
    // 参照設定に、SoundMakerPlugin を含める必要があります。
    using NintendoWare.SoundMakerPlugin;

    [Export(typeof(ISoundMakerPlugin))]
    public class SoundMakerPluginNX : ISoundMakerPlugin
    {
        [Import("NintendoWare.SoundMaker.SoundMakerPluginGeneric")]
        private ISoundMakerPlugin SoundMakerGeneric = null;
        private AppSettingsSection appSettings;
        private CommunicationInfo communicationInfo;
        private IDocumentFactory[] documentFactories;
        private IDocumentReader[] documentReaders;
        private TargetPlayerNX targetPlayerNX;

        public SoundMakerPluginNX()
        {
            Configuration config = ConfigurationManager.OpenExeConfiguration(this.GetType().Assembly.Location);
            this.appSettings = (AppSettingsSection)config.GetSection("appSettings");
            this.communicationInfo = new CommunicationInfo((this as ISoundMakerPlugin).Platform);
            this.CommunicationInfoInitialize();
            this.targetPlayerNX = new TargetPlayerNX(this.TargetAtkPlayerFilePath, this.ShutdownTargetAtkPlayerFilePath);
        }

        string ISoundMakerPlugin.Platform
        {
            get
            {
                return "NX";
            }
        }

        // Preview

        // Runtime.SoundSystemCafe

        int ISoundMakerPlugin.RuntimeSoundSystem_GetActiveVoiceCount()
        {
            return this.SoundMakerGeneric.RuntimeSoundSystem_GetActiveVoiceCount();
        }

        void ISoundMakerPlugin.RuntimeSoundSystem_LockSoundThread()
        {
            this.SoundMakerGeneric.RuntimeSoundSystem_LockSoundThread();
        }

        void ISoundMakerPlugin.RuntimeSoundSystem_UnlockSoundThread()
        {
            this.SoundMakerGeneric.RuntimeSoundSystem_UnlockSoundThread();
        }

        void ISoundMakerPlugin.RuntimeSoundSystem_StopAllVoices()
        {
            this.SoundMakerGeneric.RuntimeSoundSystem_StopAllVoices();
        }

        void ISoundMakerPlugin.RuntimeSoundSystem_SoundThreadPause(bool pauseFlag)
        {
            this.SoundMakerGeneric.RuntimeSoundSystem_SoundThreadPause(pauseFlag);
        }

        void ISoundMakerPlugin.RuntimeSoundSystem_SoundFrameProcess()
        {
            this.SoundMakerGeneric.RuntimeSoundSystem_SoundFrameProcess();
        }

        void ISoundMakerPlugin.RuntimeSoundSystem_InitSoundSystem(int soundThreadPriority, int dvdThreadPriority)
        {
            this.SoundMakerGeneric.RuntimeSoundSystem_InitSoundSystem(soundThreadPriority, dvdThreadPriority);
        }

        void ISoundMakerPlugin.RuntimeSoundSystem_ShutdownSoundSystem()
        {
            this.SoundMakerGeneric.RuntimeSoundSystem_ShutdownSoundSystem();
        }

        bool ISoundMakerPlugin.IsNwRendererEnabled
        {
            get { return this.SoundMakerGeneric.IsNwRendererEnabled; }
        }

        // Runtime.Global

        int ISoundMakerPlugin.RuntimeGlobal_DefaultSampleRate
        {
            get { return this.SoundMakerGeneric.RuntimeGlobal_DefaultSampleRate; }
        }

        int ISoundMakerPlugin.RuntimeGlobal_CHANNEL_COUNT
        {
            get
            {
                return this.SoundMakerGeneric.RuntimeGlobal_CHANNEL_COUNT;
            }
        }

        int ISoundMakerPlugin.RuntimeGlobal_MSEC_PER_FRAME
        {
            get
            {
                return this.SoundMakerGeneric.RuntimeGlobal_MSEC_PER_FRAME;
            }
        }

        int ISoundMakerPlugin.RuntimeGlobal_AXSynthesize(short[] buffer, int samplingRate)
        {
            return this.SoundMakerGeneric.RuntimeGlobal_AXSynthesize(buffer, samplingRate);
        }

        void ISoundMakerPlugin.InitializeAudioDevice(string deviceName)
        {
            this.SoundMakerGeneric.InitializeAudioDevice(deviceName);
        }

        IEnumerable<string> ISoundMakerPlugin.EnumerateAudioDeviceNames()
        {
            return this.SoundMakerGeneric.EnumerateAudioDeviceNames();
        }

        void ISoundMakerPlugin.RuntimeGlobal_AXInit()
        {
            this.SoundMakerGeneric.RuntimeGlobal_AXInit();
        }

        void ISoundMakerPlugin.RuntimeGlobal_AXQuit()
        {
            this.SoundMakerGeneric.RuntimeGlobal_AXQuit();
        }

        // Runtime.SequenceSoundPlayerCafe

        short ISoundMakerPlugin.RuntimeSequenceSoundPlayer_GetGlobalVariable(int varNo)
        {
            return this.SoundMakerGeneric.RuntimeSequenceSoundPlayer_GetGlobalVariable(varNo);
        }

        void ISoundMakerPlugin.RuntimeSequenceSoundPlayer_SetGlobalVariable(int varNo, short var)
        {
            this.SoundMakerGeneric.RuntimeSequenceSoundPlayer_SetGlobalVariable(varNo, var);
        }

        // Create

        IPreviewSequenceChannel ISoundMakerPlugin.CreatePreviewSequenceChannel(string bankFileName, Instrument instrument, ref IRuntimeNoteOnInfo noteOnInfo)
        {
            return this.SoundMakerGeneric.CreatePreviewSequenceChannel(bankFileName, instrument, ref noteOnInfo);
        }

        IPreviewSequenceChannel ISoundMakerPlugin.CreatePreviewSequenceChannel(string bankFileName, ref IRuntimeNoteOnInfo noteOnInfo, RendererType rendererType)
        {
            return this.SoundMakerGeneric.CreatePreviewSequenceChannel(bankFileName, ref noteOnInfo, rendererType);
        }

        IPreviewWaveChannel ISoundMakerPlugin.CreatePreviewWaveChannel(WaveSoundBase sound, RendererType rendererType, bool forceNoLoop)
        {
            return this.SoundMakerGeneric.CreatePreviewWaveChannel(sound, rendererType, forceNoLoop);
        }

        IPreviewStreamChannel ISoundMakerPlugin.CreatePreviewStreamChannel(
            StreamSoundTrackBase streamTrack,
            StreamSoundTrackBase baseTrack,
            int channelIndexStart,
            float volume,
            float pitch,
            PanMode panMode,
            PanCurve panCurve,
            float mainSend,
            RendererType rendererType,
            bool forceNoLoop)
        {
            return this.SoundMakerGeneric.CreatePreviewStreamChannel(streamTrack, baseTrack, channelIndexStart, volume, pitch, panMode, panCurve, mainSend, rendererType, forceNoLoop);
        }

        ISequenceSoundPlayer ISoundMakerPlugin.CreateSequenceSoundPlayer()
        {
            return this.SoundMakerGeneric.CreateSequenceSoundPlayer();
        }

        ISeqFileReader ISoundMakerPlugin.CreateSeqFileReader(IntPtr seqData)
        {
            return this.SoundMakerGeneric.CreateSeqFileReader(seqData);
        }

        ISequenceSoundBinaryReader ISoundMakerPlugin.CreateSequenceSoundBinaryReader()
        {
            return this.SoundMakerGeneric.CreateSequenceSoundBinaryReader();
        }

        IMidiManager ISoundMakerPlugin.CreateMidiManager()
        {
            return this.SoundMakerGeneric.CreateMidiManager();
        }

        // Converter 関連

        CreateSoundProjectConverterDelegate ISoundMakerPlugin.GetCreateSoundProjectConverterDelegate()
        {
            return this.SoundMakerGeneric.GetCreateSoundProjectConverterDelegate();
        }

        CreateSoundIDCppHeaderExporterDelegate ISoundMakerPlugin.GetCreateSoundIDCppHeaderExporterDelegate()
        {
            return this.SoundMakerGeneric.GetCreateSoundIDCppHeaderExporterDelegate();
        }

        CreateFileIDAggregateFactoryDelegate ISoundMakerPlugin.GetCreateFileIDAggregateFactoryDelegate()
        {
            return this.SoundMakerGeneric.GetCreateFileIDAggregateFactoryDelegate();
        }

        CreateFileIDDelegate ISoundMakerPlugin.GetCreateFileIDDelegate()
        {
            return this.SoundMakerGeneric.GetCreateFileIDDelegate();
        }

        CreateSoundArchiveBinaryXmlDelegate ISoundMakerPlugin.GetCreateSoundArchiveBinaryXmlDelegate()
        {
            return this.SoundMakerGeneric.GetCreateSoundArchiveBinaryXmlDelegate();
        }

        CreateWaveFileInfoDelegate ISoundMakerPlugin.GetCreateWaveFileInfoDelegate()
        {
            return this.SoundMakerGeneric.GetCreateWaveFileInfoDelegate();
        }

        CreateSoundArchiveBinaryMapExporterDelegate ISoundMakerPlugin.GetCreateSoundArchiveBinaryMapExporterDelegate()
        {
            return this.SoundMakerGeneric.GetCreateSoundArchiveBinaryMapExporterDelegate();
        }

        // 接続関連
        CommunicationInfo ISoundMakerPlugin.CommunicationInfo
        {
            get
            {
                return this.communicationInfo;
            }
        }

        private void CommunicationInfoInitialize()
        {
            ConnectionInfo[] connectionInfos =
                {
#if USE_NWSND
                    new ConnectionInfo("PCApplication_nwsnd", MessageResource.PCApplication_nwsnd, false, null, null, null, null, null, null, null, null),
#endif
#if USE_PCSOUNDPLAYER
                    new ConnectionInfo("PCSoundPlayer_nwsnd", MessageResource.PCSoundPlayer_nwsnd, false, null, null, null, null, null, null, null, null),
#endif
                    new ConnectionInfo("PCApplication", MessageResource.PCApplication, false, null, null, null, null, null, null, null, null, "NX-Windows"),
                    new ConnectionInfo("TargetApplication", MessageResource.TargetApplication, false, null, null, null, null, null, null, null, null, "NX-NX"),
                };

            foreach (ConnectionInfo info in connectionInfos)
            {
                this.communicationInfo.SetConnectionInfo(info.TargetName, info);
            }
        }

        // その他
        void ISoundMakerPlugin.Initialize(SoundSetComponentFactory soundSetComponentFactory)
        {
            this.documentFactories = new IDocumentFactory[] { };
            this.documentReaders = new IDocumentReader[] { };
        }

        IEnumerable<IDocumentFactory> ISoundMakerPlugin.DocumentFactories
        {
            get { return this.documentFactories; }
        }

        IEnumerable<IDocumentReader> ISoundMakerPlugin.DocumentReaders
        {
            get { return this.documentReaders; }
        }

        string ISoundMakerPlugin.GetExpandedAppSetting(string key)
        {
            if (this.appSettings.Settings.AllKeys.Contains(key) == false)
            {
                return string.Empty;
            }

            return this.ExpandMacro(this.appSettings.Settings[key].Value);
        }

        // コントロール関係
        string ISoundMakerPlugin.PlatformLabel
        {
            get
            {
                return "NX";
            }
        }

        bool ISoundMakerPlugin.IsValidateWaveEncodingValue(WaveEncoding encoding)
        {
            switch (encoding)
            {
                case WaveEncoding.Pcm16:
                case WaveEncoding.Adpcm:
                case WaveEncoding.NoConvert:
                    return true;

                default:
                    return false;
            }
        }

        // 実機 AtkPlayer 関係
        ITargetPlayer ISoundMakerPlugin.TargetPlayer
        {
            get
            {
                return this.targetPlayerNX;
            }
        }

        private string TargetAtkPlayerFilePath
        {
            get
            {
                return (this as ISoundMakerPlugin).GetExpandedAppSetting("TargetAtkPlayerFilePath");
            }
        }

        private string ShutdownTargetAtkPlayerFilePath
        {
            get
            {
                return (this as ISoundMakerPlugin).GetExpandedAppSetting("ShutdownTargetAtkPlayerFilePath");
            }
        }

        private string ExpandMacro(string value)
        {
            {
                string executingDirectory = Path.GetFullPath(Path.GetDirectoryName(Assembly.GetEntryAssembly().Location));
                value = value.Replace("$(SoundMakerDirectory)", executingDirectory);
            }
            return value;
        }

        //////
#if DEBUG
        string ISoundMakerPlugin.GetMessage()
        {
            return "SoundMaker NX !!";
        }
#endif
    }
}
