﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Preview
{
    using System;
    using System.Collections;
    using System.Diagnostics;
    using System.IO;
    using System.Reflection;
    using System.Windows.Forms;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker;

    public static class AtkPlayerNX
    {
        ///--------------------------------
        /// <summary>
        /// 実機版 AtkPlayer の起動
        /// </summary>
        public static void Start(string atkPlayerFilePath, string soundArchiveFilePath)
        {
            Cursor oldCursor = Cursor.Current;

            try
            {
                Cursor.Current = Cursors.WaitCursor;

                RunAtkPlayer(atkPlayerFilePath, soundArchiveFilePath);
            }
            finally
            {
                Cursor.Current = oldCursor;
            }
        }

        private static void RunAtkPlayer(string atkPlayerFilePath, string soundArchiveFilePath)
        {
            if (File.Exists(atkPlayerFilePath) == false)
            {
                return;
            }

            /******************************************************************************
               コマンドライン引数の作成
            ******************************************************************************/
            string arguments = soundArchiveFilePath;

            /******************************************************************************
                ProcessStartInfoの作成
            ******************************************************************************/
            ProcessStartInfo startInfo = new ProcessStartInfo(atkPlayerFilePath);
            startInfo.Arguments = arguments;
            startInfo.WorkingDirectory = atkPlayerFilePath;

            /******************************************************************************
               プロセスの起動
            ******************************************************************************/
            Process atkPlayer = Process.Start(startInfo);
        }

        ///--------------------------------
        /// <summary>
        /// 実機版 AtkPlayer の停止
        /// </summary>
        public static void Stop(string shutdownAtkPlayerFilePath)
        {
            Cursor oldCursor = Cursor.Current;

            try
            {
                Cursor.Current = Cursors.WaitCursor;

                ShutdownAtkPlayer(shutdownAtkPlayerFilePath);
            }
            finally
            {
                Cursor.Current = oldCursor;
            }
        }

        private static void ShutdownAtkPlayer(string shutdownAtkPlayerFilePath)
        {
            ProcessStartInfo startInfo = new ProcessStartInfo(shutdownAtkPlayerFilePath);
            startInfo.WorkingDirectory = shutdownAtkPlayerFilePath;

            /******************************************************************************
               プロセスの起動
            ******************************************************************************/
            Process OdStop = Process.Start(startInfo);
            OdStop.WaitForExit();
        }
    }
}
