﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker
{
    using NintendoWare.SoundMakerPlugin;
    using Runtime = NintendoWare.SoundRuntime;

    public class MidiManagerGeneric : IMidiManager
    {
        private Runtime.MidiManagerCafe midiManager;

        public MidiManagerGeneric()
        {
            this.midiManager = new Runtime.MidiManagerCafe();
        }

        IntPtr IMidiManager.GetSequenceSoundPlayerHandle(uint devideID)
        {
            return this.midiManager.GetSequenceSoundPlayerHandle(devideID);
        }

        bool IMidiManager.IsActive(uint msec)
        {
            return this.midiManager.IsActive(msec);
        }

        bool IMidiManager.OpenMidiIn(uint deviceID)
        {
            return this.midiManager.OpenMidiIn(deviceID);
        }

        void IMidiManager.ProgramChange(int channelIndex, int prgNo)
        {
            this.midiManager.ProgramChange(channelIndex, prgNo);
        }

        void IMidiManager.ProgramChange(uint devideID, int channelIndex, int prgNo)
        {
            this.midiManager.ProgramChange(devideID, channelIndex, prgNo);
        }

        void IMidiManager.Reset()
        {
            this.midiManager.Reset();
        }

        void IMidiManager.SendMidiMessage(int status, int data1, int data2)
        {
            this.midiManager.SendMidiMessage(status, data1, data2);
        }

        void IMidiManager.Setup(RuntimeNoteOnCallback noteOnCallback, object userData)
        {
            Runtime.NoteOnCallback callback = (IntPtr seqPlayer, int bankNo, ref Runtime.NoteOnInfo noteOnInfo, object uData) =>
                {
                    IRuntimeNoteOnInfo rnoInfo = new RuntimeNoteOnInfo(noteOnInfo);
                    Runtime.ChannelCafe ch = (Runtime.ChannelCafe)noteOnCallback(seqPlayer, bankNo, ref rnoInfo, uData);
                    noteOnInfo = (rnoInfo as RuntimeNoteOnInfo).NoteOnInfo;
                    return ch;
                };

            this.midiManager.Setup(callback, userData);
        }

        void IMidiManager.Shutdown()
        {
            this.midiManager.Shutdown();
        }
    }
}
