﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.FileFormats.NintendoWareBinary
{
    using SoundFoundation.FileFormats.NintendoWareBinary;
    using SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveXmlElements;

    public class SoundArchiveBinaryXmlCafe : ISoundArchiveBinaryXml
    {
        NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveBinaryXml soundArchiveBinaryXml;

        public SoundArchiveBinaryXmlCafe(NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveBinaryXml soundArchiveBinaryXml)
        {
            this.soundArchiveBinaryXml = soundArchiveBinaryXml;
        }

        public bool GetGroupXmlTotalSize(string groupXmlName, out ulong totalSize)
        {
            foreach (NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveXmlElements.GroupXml groupXml in this.soundArchiveBinaryXml.Groups)
            {
                if (groupXmlName == groupXml.Name)
                {
                    totalSize = groupXml.TotalSize;
                    return true;
                }
            }

            totalSize = 0;
            return false;
        }
    }
}
