﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "StdAfx.h"
#include "SeqPlayer.h"

UnmanagedSequenceSoundPlayer::UnmanagedSequenceSoundPlayer()
: mTrackAllocator( &mMmlParser ),
  mNoteOnCallback( NULL ),
  mUserData( NULL )
{
    mMmlSequenceTrackBuffer = new uint8_t[ TRACK_BUFFER_SIZE ];
    mTrackAllocator.Create( mMmlSequenceTrackBuffer, TRACK_BUFFER_SIZE );
}

UnmanagedSequenceSoundPlayer::~UnmanagedSequenceSoundPlayer()
{
    mTrackAllocator.Destroy();
    delete[] mMmlSequenceTrackBuffer;
}

bool UnmanagedSequenceSoundPlayer::Setup(
        uint32_t allocTrackFlag,
        NoteOnCallback noteOnCallback,
        void* userData )
{
    nn::atk::detail::driver::SequenceSoundPlayer::SetupArg arg;
    arg.trackAllocator = &mTrackAllocator;
    arg.allocTracks = allocTrackFlag;
    arg.callback = this;
    mPlayer.Setup(arg);

    mNoteOnCallback = noteOnCallback;
    mUserData = userData;
    return true;
}

nn::atk::detail::driver::Channel* UnmanagedSequenceSoundPlayer::NoteOn(
    nn::atk::detail::driver::SequenceSoundPlayer* seqPlayer,
    uint8_t bankIndex,
    const nn::atk::detail::driver::NoteOnInfo& noteOnInfo
)
{
    if ( mNoteOnCallback == NULL ) {
        return NULL;
    }

    return mNoteOnCallback( seqPlayer, bankIndex, noteOnInfo, mUserData );
}

short UnmanagedSequenceSoundPlayer::GetTrackVariable( int trackNo, int varNo ) const
{
    const nn::atk::detail::driver::SequenceTrack* track = mPlayer.GetPlayerTrack( trackNo );
    if ( track == NULL ) return nn::atk::detail::driver::SequenceSoundPlayer::VariableDefaultValue;
    return track->GetTrackVariable(varNo);
}

void UnmanagedSequenceSoundPlayer::SetTrackVariable( int trackNo, int varNo, short var )
{
    nn::atk::detail::driver::SequenceTrack* track = mPlayer.GetPlayerTrack( trackNo );
    if ( track == NULL ) return;
    track->SetTrackVariable(varNo,var);
}

