﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#if !defined(AFX_NITRO_H__1F7DEA24_379A_49A8_A97A_55C456684AE9__INCLUDED_)
#define AFX_NITRO_H__1F7DEA24_379A_49A8_A97A_55C456684AE9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <iostream>
#include "stream.h"

namespace sndlib
{

namespace nitro
{

using namespace std;

#ifdef NW_PLATFORM_RVL
    typedef BigEndian OutputEndian;
    static const int OFFSET_TO_FILESIZE = 8;
    static const int OFFSET_TO_HEADERSIZE = 12;
    static const int BINARY_FILE_HEADER_SIZE = 16;
#else
    typedef LittleEndian OutputEndian;
    static const int OFFSET_TO_FILESIZE = 12;
    static const int OFFSET_TO_HEADERSIZE = 16;
    static const int BINARY_FILE_HEADER_SIZE = 20;
#endif /* NW_PLATFORM_RVL */

typedef strm::binary<uint8_t,  OutputEndian> u8;
typedef strm::binary<int8_t,   OutputEndian> s8;
typedef strm::binary<uint16_t, OutputEndian> u16;
typedef strm::binary<int16_t,  OutputEndian> s16;
typedef strm::binary<uint32_t, OutputEndian> u32;
typedef strm::binary<int32_t,  OutputEndian> s32;
typedef strm::binary<float32_t, OutputEndian> f32;

struct SNDHeader
{
    u32 signature;
    u16 byteOrder;
#ifdef NW_PLATFORM_RVL
    u16 version;
#else
    u16 reserved;
    u32 version;
#endif
    u32 fileSize;
    u16 headerSize;
    u16 dataBlocks;
};

struct Header
{
    Header(
        uint32_t tag_,
#ifdef NW_PLATFORM_RVL
        u16 version,
#else
        u32 version,
#endif /* NW_PLATFORM_RVL */
        u16 dataBlocks,
        strm::fstream& out_ )
        : out( out_ ),
          begin( out_.tell() )
    {
        out
            << strm::char4( tag_ )
            << u16( 0xfeff ) // byteOrder
#ifdef NW_PLATFORM_RVL
            << u16( version )
#else
            << u16( 0 ) // reserved
            << u32( version )
#endif /* NW_PLATFORM_RVL */
            << u32( 0 )    // fileSize reserved
            << u16( 16 )   // headerSize
            << u16( dataBlocks )

            << strm::align(4)
            ;
    }
    ~Header()
    {
        //
        out << strm::align(4);

        // fileSize の書き戻し
        long end = out.tell();
        out.seek( begin + OFFSET_TO_FILESIZE );
        out << u32( end - begin );
        out.seek( end );
    }

    void EndOfHeader()
    {
        out << strm::align(4);

        long pos = out.tell();
        out.seek( begin + OFFSET_TO_HEADERSIZE );
        out << u16( static_cast< uint16_t >( pos - begin ) );
        out.seek( pos );
    }

    strm::fstream& out;
    long begin;
};

struct DataBlock
{
    DataBlock(uint32_t tag_, strm::fstream& out_)
        : out(out_)
    {
        blockBegin = out.tell();
        out << strm::char4(tag_);
        blockSizePos = out.tell();
        out << u32( 0 ); // reserved
    }
    ~DataBlock()
    {
        //
        out << strm::align(4);

        // 後処理
        long blockEnd = out.tell();
        out.seek( blockSizePos );
        out << u32( blockEnd - blockBegin );
        out.seek( blockEnd );
    }

    strm::fstream& out;
    long blockBegin;
    long blockSizePos;
};

} // end of namespace nitro

} // namespace sndlib

#endif // !defined(AFX_NITRO_H__1F7DEA24_379A_49A8_A97A_55C456684AE9__INCLUDED_)

