﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#if !defined(AFX_ENDIAN_H__403F0FD8_8F44_4B34_A8E9_47CA9E54FFC9__INCLUDED_)
#define AFX_ENDIAN_H__403F0FD8_8F44_4B34_A8E9_47CA9E54FFC9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef WIN32
#define LITTLE_ENDIAN
#endif

#ifdef LITTLE_ENDIAN

#ifdef BIG_ENDIAN
#error both LITTLE_ENDIAN and BIG_ENDIAN defined
#endif

#else

#ifndef BIG_ENDIAN
#error either LITTLE_ENDIAN nor BIG_ENDIAN not defined
#endif

#endif



#include <algorithm>

namespace sndlib
{

namespace {

template<typename T>
T flip(const T& x)
{
    T y;
    const char* src_p = reinterpret_cast<const char*>(&x) + sizeof(T) - 1;
    char* dest_p = reinterpret_cast<char*>(&y);
    int i;
    for(i = 0 ; i < sizeof(T) ; ++i) {
        *dest_p++ = *src_p--;
    }
    return y;
}

void flip(void* x, int size)
{
    char* p = reinterpret_cast<char*>(x);
    int i;
    for(i = 0 ; i < size/2 ; ++i) {
        std::swap(p[i], p[size - 1 - i]);
    }
}

}

struct BigEndian
{
    template<typename T>
    static T convert(const T& x) {
#ifdef LITTLE_ENDIAN
        return flip(x);
#else // BIG_ENDIAN
        return x;
#endif
    }
    static void convert(void* x, int size) {
#ifdef LITTLE_ENDIAN
        flip(x, size);
        return;
#else // BIG_ENDIAN
        (void)x;
        (void)size;
        return;
#endif
    }
};

struct LittleEndian
{
    template<typename T>
    static T convert(const T& x) {
#ifdef LITTLE_ENDIAN
        return x;
#else // BIG_ENDIAN
        return flip(x);
#endif
    }
    static void convert(void* x, int size) {
#ifdef LITTLE_ENDIAN
        (void)x;
        (void)size;
        return;
#else // BIG_ENDIAN
        flip(x, size);
        return;
#endif
    }
};

} // namespace sndlib

#endif // !defined(AFX_ENDIAN_H__403F0FD8_8F44_4B34_A8E9_47CA9E54FFC9__INCLUDED_)

