﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifdef _WINDLL
#define ATKTOOL_DLLAPI __declspec(dllexport)
#else
#define ATKTOOL_DLLAPI __declspec(dllimport)
#endif

#include <stdint.h>

namespace nn { namespace atkTool {

class ATKTOOL_DLLAPI WaveDataUtility
{
public:
    // =========================================================================
    enum Result
    {
        Result_Success = 0,
        Result_OutOfMemory,
        Result_BeforeInitialize,
        Result_InvalidFormat,
        Result_FailedToOpen,
        Result_NullData,
        Result_NullSize,
        Result_InvalidSize,
        Result_NullBuffer,
        Result_NullDumpFilePath,
        Result_InvalidChannel,
        Result_NullAdpcmContext,
        Result_NullWaveInfo,
        Result_NullAdjustOffsetSample,
        Result_InvalidOffsetSample,
        Result_Unsupported,
        Result_FailureDecode
    };

    // =========================================================================
    struct AdpcmContext
    {
        uint16_t pred_scale; //!< Adpcm の予測値（4bit）、スケール値（4bit）を格納します。上位8ビットは参照されません。
        int16_t yn1;        //!< 履歴データ（1 つ前のサンプル値）
        int16_t yn2;        //!< 履歴データ（2 つ前のサンプル値）
    };

    // -------------------------------------------------------------------------
    struct WaveInfo
    {
        int32_t channelCount;
        int32_t sampleRate;
        int32_t sampleCount;
        int32_t loopStart;
        int32_t loopEnd;
        bool loopFlag;  // true だとループあり。false だとループ無し。
                        // false の場合は loopStart/End を参照してはいけません。
    };

    // =========================================================================
    WaveDataUtility();
    ~WaveDataUtility();
    Result Initialize           (const void* data);
    Result DumpDecodedSamples   (const char* dumpFilePath);
    Result GetRequiredMemorySizeForDecodedSamples(size_t* size);
    Result GetDecodedSamples    (int channel, void* bufferForDecodedSamples, size_t size);
    Result GetAdpcmContext      (int channel, int offsetSample, int* adjustOffsetSample, AdpcmContext* context);
    Result GetWaveInfo          (WaveInfo* info);
    Result Finalize             ();
private:
    class WaveDataUtilityImpl;
    WaveDataUtilityImpl* m_pImpl;
};

}} // nn::atkTool
