﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Drawing;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NintendoWare.SoundMaker
{
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.Windows;
    using NintendoWare.SoundMaker.Preview.Communications;
    using NintendoWare.SoundMaker.Resources;
    using NintendoWare.SoundMakerPlugin;

    public class TargetPlayerCafe : ITargetPlayer
    {
        private string soundPlayerDirectory = string.Empty;
        private string soundPlayerContentsDirectory = string.Empty;

        public TargetPlayerCafe(string soundPlayerDirectory, string soundPlayerContentsDirectory)
        {
            this.soundPlayerDirectory = soundPlayerDirectory;
            this.soundPlayerContentsDirectory = soundPlayerContentsDirectory;
        }


        void ITargetPlayer.Run(TargetPlayerRunArgument args)
        {
            Preview.SoundPlayer.Start(this.soundPlayerContentsDirectory, args.ProjectDocument, this.soundPlayerDirectory);
        }

        void ITargetPlayer.Shutdown()
        {
            Preview.SoundPlayer.Stop(this.soundPlayerDirectory);
        }

        string ITargetPlayer.UIRunMenuText
        {
            get
            {
                return MessageResource.Command_Preview_RunSoundPlayer_MenuText;
            }
        }

        string ITargetPlayer.UIRunButtonText
        {
            get
            {
                return MessageResource.Command_Preview_RunSoundPlayer_ButtonText;
            }
        }

        string ITargetPlayer.UIRunToolTipText
        {
            get
            {
                return MessageResource.Command_Preview_RunSoundPlayer_ToolTipText;
            }
        }

        Image ITargetPlayer.UIRunIconImage
        {
            get
            {
                return ImageResource.BitmapIconRunSoundPlayer.MakeNewTransparent(UIServiceBase.TransparentColor);
            }
        }

        string ITargetPlayer.UIConfirmRunTitle
        {
            get
            {
                return MessageResource.ConfirmRunSoundPlayerTitle;
            }
        }

        string ITargetPlayer.UIConfirmRunMessage
        {
            get
            {
                return MessageResource.ConfirmRunSoundPlayer;
            }
        }

        string ITargetPlayer.UIShutdownMenuText
        {
            get
            {
                return MessageResource.Command_Preview_ShutdownSoundPlayer_Text;
            }
        }
    }
}
