﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;

using NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat.Model;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat
{
    /// <summary>
    /// バンクインクルードファイル クラス
    /// </summary>
    internal class Nw4rBankIncludeFile
    {
        #region ** フィールド

        private Nw4rBank _bank;		// バンク

        #endregion

        public Nw4rBankIncludeFile(Nw4rBank bank)
        {
            if (null == bank) { throw new Nw4rFileFormatInternalException(new ArgumentNullException("bank")); }
            _bank = bank;
        }

        #region ** プロパティ

        private Nw4rBank Bank
        {
            get { return _bank; }
        }

        #endregion

        #region ** メソッド

        public void Write(TextWriter writer)
        {
            if (null == writer) { throw new Nw4rFileFormatInternalException(new ArgumentNullException("writer")); }

            WriteItems(writer);
        }

        private void WriteItems(TextWriter writer)
        {
            Debug.Assert(null != _bank);

            // プログラム番号順に出力する
            SortedList<int, Nw4rInstrument> indexedInstruments = new SortedList<int, Nw4rInstrument>();

            foreach (Nw4rInstrument instrument in _bank.Components)
            {
                indexedInstruments.Add(instrument.XmlData.PrgNo, instrument);
            }

            foreach (Nw4rInstrument instrument in indexedInstruments.Values)
            {
                writer.WriteLine("#define\t{0}\t{1}", instrument.Label, instrument.XmlData.PrgNo.ToString());
            }
        }

        #endregion
    }
}
