﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat.Model
{
    /// <summary>
    /// 添付プロパティ識別子
    /// </summary>
    public struct AttachedPropertyID
    {
        object _object;
        string _name;

        public AttachedPropertyID(object obj, string name)
        {
            Debug.Assert(null != obj);
            Debug.Assert(null != name);
            Debug.Assert(0 < name.Length);

            _object = obj;
            _name = name;
        }

        #region ** プロパティ

        object Object
        {
            get { return _object; }
        }

        string Name
        {
            get { return _name; }
        }

        #endregion

        #region ** メソッド

        public override bool Equals(object obj)
        {
            if (null == obj || !(obj is AttachedPropertyID)) { return false; }

            AttachedPropertyID target = (AttachedPropertyID)obj;
            return (Name.Equals(target.Name) && Object == target.Object);
        }

        public override int GetHashCode()
        {
            return _object.GetHashCode() ^ _name.GetHashCode();
        }

        #endregion
    }

    /// <summary>
    /// 添付プロパティ コンテナ
    /// </summary>
    public class AttachedPropertyDictionary : Dictionary<AttachedPropertyID, object> { }
}
