﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Text;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat
{

    public class BinaryReaderBigEndian
    {
        public static BinaryReader CreateInstance(Stream s)
        {
            if (BitConverter.IsLittleEndian) return new BinaryReaderReverseEndian(s);
            return new BinaryReader(s);
        }
        public static BinaryReader CreateInstance(Stream s, Encoding e)
        {
            if (BitConverter.IsLittleEndian) return new BinaryReaderReverseEndian(s, e);
            return new BinaryReader(s, e);
        }
    }
    public class BinaryReaderLittleEndian
    {
        public static BinaryReader CreateInstance(Stream s)
        {
            if (BitConverter.IsLittleEndian) return new BinaryReader(s);
            return new BinaryReaderReverseEndian(s);
        }
        public static BinaryReader CreateInstance(Stream s, Encoding e)
        {
            if (BitConverter.IsLittleEndian) return new BinaryReader(s, e);
            return new BinaryReaderReverseEndian(s, e);
        }
    }

    class BinaryReaderReverseEndian : BinaryReader
    {
        public BinaryReaderReverseEndian(Stream s) : base(s) { }
        public BinaryReaderReverseEndian(Stream s, Encoding e) : base(s, e) { }

        public override short ReadInt16()
        {
            byte[] bytes = base.ReadBytes(2);
            Array.Reverse(bytes);
            return BitConverter.ToInt16(bytes, 0);
        }
        public override int ReadInt32()
        {
            byte[] bytes = base.ReadBytes(4);
            Array.Reverse(bytes);
            return BitConverter.ToInt32(bytes, 0);
        }
        public override ushort ReadUInt16()
        {
            byte[] bytes = base.ReadBytes(2);
            Array.Reverse(bytes);
            return BitConverter.ToUInt16(bytes, 0);
        }
        public override uint ReadUInt32()
        {
            byte[] bytes = base.ReadBytes(4);
            Array.Reverse(bytes);
            return BitConverter.ToUInt32(bytes, 0);
        }
    }

}

