﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.ToolDevelopmentKit;

    public class CTRParameterValue : ComplexParameterValue<CTRParameter>
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public CTRParameterValue()
            : this(new CTRParameter())
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="value">パラメータの値を指定します。</param>
        public CTRParameterValue(CTRParameter value)
            : base(value)
        {
            SetParameterAttributes(CTRParameter.PropertyNameFrontBypass, ParameterAttributes.ComputeSoundArchiveHash);
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// FrontBypass を取得または設定します。
        /// </summary>
        public BoolParameterValue FrontBypass
        {
            get { return this.Parameters[CTRParameter.PropertyNameFrontBypass] as BoolParameterValue; }
        }

        /// <summary>
        /// XML シリアライズ時の要素名を取得します。
        /// </summary>
        protected override string XmlElementName
        {
            get
            {
                return ProjectParameterNamesCtr.Sound.CTRParams;
            }
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// パラメータの値を取得するキャストオペレータです。
        /// </summary>
        /// <param name="value">対象となるパラメータ値を指定します。</param>
        /// <returns>パラメータの値を返します。</returns>
        public static implicit operator CTRParameter(CTRParameterValue value)
        {
            Ensure.Argument.NotNull(value);
            return value.Value;
        }
    }
}
