﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.SoundFoundation.Projects;
    using ToolDevelopmentKit;

    public class SoundSetItemParamTranslatorCtr : SoundSetItemParamTranslator
    {
        public SoundSetItemParamTranslatorCtr()
            : base()
        {
            this.AddHandler(ProjectParameterNamesCtr.Sound.CTRParams, typeof(XmlCTRParam),
                            this.XmlCTRParam2Model, this.Model2XmlCTRParam);
        }

        //-----------------------------------------------------------------
        // CTR Param
        //-----------------------------------------------------------------

        private void XmlCTRParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlCTRParam src = paramXml as XmlCTRParam;
            CTRParameterValue destValue = dest.Parameters[src.Name] as CTRParameterValue;
            if (destValue == null)
            {
                destValue = new CTRParameterValue();
                dest.Parameters.AddValue(src.Name, destValue);
            }

            foreach (XmlParameter xmlParameter in src.Parameters)
            {
                this.Xml2Model(xmlParameter, destValue);
            }
        }

        private void Model2XmlCTRParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
#if false
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is CTRParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            CTRParameterValue srcValue = value as CTRParameterValue;
            XmlCTRParam destValue = new XmlCTRParam();

            foreach (string key in srcValue.Parameters.Keys)
            {
                this.Model2Xml(key, srcValue.Parameters[key], destValue);
            }

            dest.Parameters.Add(destValue);
#endif
        }
    }
}
