﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using NintendoWare.SoundFoundation.Projects;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Conversion;

    public class SoundSetModel2XmlTranslatorCtr : SoundSetModel2XmlTranslator
    {
        public SoundSetModel2XmlTranslatorCtr()
            : base(new SoundSetItemParamTranslatorCtr())
        {
            this.AddConverter<SoundSet, XmlSoundSetCtr>(this.ComponentToXmlComponentWithoutName<SoundSet, XmlSoundSetCtr>);
            this.AddConverter<StreamSoundPack, XmlSoundSetItemFolderCtr>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<WaveSoundSetPack, XmlSoundSetItemFolderCtr>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<SequenceSoundSetPack, XmlSoundSetItemFolderCtr>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<SequenceSoundPack, XmlSoundSetItemFolderCtr>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<SoundSetBankPack, XmlSoundSetItemFolderCtr>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<PlayerPack, XmlSoundSetItemFolderCtr>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<WaveArchivePack, XmlSoundSetItemFolderCtr>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<GroupPack, XmlSoundSetItemFolderCtr>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<StreamSoundCtr, XmlStreamSoundCtr>();
            this.AddConverter<StreamSoundTrackCtr, XmlStreamSoundTrack>();
            this.AddConverter<WaveSoundSetBase, XmlWaveSoundSetCtr>();
            this.AddConverter<WaveSoundCtr, XmlWaveSoundCtr>();
            this.AddConverter<SequenceSoundSetBase, XmlSequenceSoundSetCtr>();
            this.AddConverter<SequenceSoundCtr, XmlSequenceSoundCtr>();
            this.AddConverter<SoundSetBankBase, XmlSoundSetBank>();
            this.AddConverter<PlayerBase, XmlPlayer>();
            this.AddConverter<WaveArchiveBase, XmlWaveArchive>();
            this.AddConverter<GroupBase, XmlGroup>();
            this.AddConverter<GroupItemBase, XmlGroupItem>();
        }

        new public XmlSoundSetCtr Run(SoundSet soundSetCtr)
        {
            return this.Run<XmlSoundSetCtr>(soundSetCtr) as XmlSoundSetCtr;
        }

        /// <summary>
        /// SoundSetItemPack から XmlSoundSetItemFolder に変換します。
        /// </summary>
        /// <param name="src">変換元のオブジェクトを指定します。</param>
        /// <param name="dstType">変換後の型を指定します。</param>
        /// <param name="converter">変換の状態です。Converterから渡されます。</param>
        /// <returns>変換後のオブジェクトを返します。</returns>
        private object SoundSetItemPackToXmlSoundSetItemFolder(object src, Type dstType, Converter converter)
        {
            Assertion.Argument.True(src is SoundSetItemPack);
            Assertion.Argument.True(dstType == typeof(XmlSoundSetItemFolderCtr));

            SoundSetItemPack srcItem = src as SoundSetItemPack;
            XmlSoundSetItemFolderCtr dest = new XmlSoundSetItemFolderCtr()
            {
                Name = srcItem.Name,
            };

            TranslateParameters(srcItem, dest, converter);
            TranslateChildren(srcItem, dest, converter);

            return dest;
        }
    }
}
