﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.SoundFoundation.Core.IO;
using System.IO;

namespace NintendoWare.SoundProjectUtility
{
    internal static class PathUtility
    {
        internal static string FormatFilePath(
            string filePath,
            string basePath = null,
            bool useBackslash = false)
        {
            // 仕様によりフルパス化。
            filePath = Path.GetFullPath(filePath);

            if (basePath != null)
            {
                filePath = PathEx.MakeRelative(filePath, basePath);
            }
            else
            {
                filePath = PathEx.Normalize(filePath);
            }

            if (useBackslash)
            {
                filePath = filePath.Replace('/', Path.DirectorySeparatorChar);
            }

            return filePath;
        }
    }
}
