﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NintendoWare.SoundMakerPlugin
{
    using NintendoWare.SoundFoundation.Projects;

    public struct TargetPlayerRunArgument
    {
        private SoundProjectDocument projectDocument;
        private string soundArchivePath;

        public SoundProjectDocument ProjectDocument
        {
            get
            {
                return projectDocument;
            }
        }

        public string SoundArchivePath
        {
            get
            {
                return soundArchivePath;
            }
        }

        public TargetPlayerRunArgument(SoundProjectDocument document, string path)
        {
            projectDocument = document;
            soundArchivePath = path;
        }
    }
}
