﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows
{
    using System;
    using System.Drawing;

    /// <summary>
    /// UI 機能する基本クラスです。
    /// </summary>
    public abstract class UIServiceBase
    {
        /// <summary>
        /// 画像の透過色を取得します。
        /// </summary>
        public static readonly Color TransparentColor = Color.Magenta;

        /// <summary>
        /// プロジェクト設定ダイアログからプロジェクト設定が変更されたら発生します。
        /// </summary>
        public event EventHandler ProjectSettingsChanged;

        /// <summary>
        /// UIサービスを初期化します。
        /// </summary>
        public virtual void Initialize() { }

        /// <summary>
        /// メッセージボックスを表示します。
        /// </summary>
        /// <param name="text">テキスト。</param>
        /// <returns>結果。</returns>
        public AppMessageBoxResult ShowMessageBox(string text)
        {
            return ShowMessageBox(text, null);
        }

        /// <summary>
        /// メッセージボックスを表示します。
        /// </summary>
        /// <param name="text">テキスト。</param>
        /// <param name="caption">キャプション。</param>
        /// <returns>結果。</returns>
        public AppMessageBoxResult ShowMessageBox(string text, string caption)
        {
            return ShowMessageBox(text, caption, AppMessageBoxButton.OK, AppMessageBoxImage.None, AppMessageBoxResult.OK);
        }

        /// <summary>
        /// メッセージボックスを表示します。
        /// </summary>
        /// <param name="text">テキスト。</param>
        /// <param name="button">ボタンの種類。</param>
        /// <param name="image">アイコン。</param>
        /// <returns>結果。</returns>
        public AppMessageBoxResult ShowMessageBox(string text, AppMessageBoxButton button, AppMessageBoxImage image)
        {
            return ShowMessageBox(text, null, button, image, AppMessageBoxResult.None);
        }

        /// <summary>
        /// メッセージボックスを表示します。
        /// </summary>
        /// <param name="text">テキスト。</param>
        /// <param name="caption">キャプション。</param>
        /// <param name="button">ボタンの種類。</param>
        /// <param name="image">アイコン。</param>
        /// <returns>結果。</returns>
        public AppMessageBoxResult ShowMessageBox(string text, string caption, AppMessageBoxButton button, AppMessageBoxImage image)
        {
            return ShowMessageBox(text, caption, button, image, AppMessageBoxResult.None);
        }

        /// <summary>
        /// メッセージボックスを表示します。
        /// </summary>
        /// <param name="text">テキスト。</param>
        /// <param name="button">ボタンの種類。</param>
        /// <param name="image">アイコン。</param>
        /// <param name="defaultResult">デフォルトの結果。</param>
        /// <returns>結果。</returns>
        public AppMessageBoxResult ShowMessageBox(string text, AppMessageBoxButton button,
                                                   AppMessageBoxImage image, AppMessageBoxResult defaultResult)
        {
            return ShowMessageBox(text, null, button, image, defaultResult);
        }

        /// <summary>
        /// メッセージボックスを表示します。
        /// </summary>
        /// <param name="text">テキスト。</param>
        /// <param name="caption">キャプション。</param>
        /// <param name="button">ボタンの種類。</param>
        /// <param name="image">アイコン。</param>
        /// <param name="defaultResult">デフォルトの結果。</param>
        /// <returns>結果。</returns>
        public abstract AppMessageBoxResult ShowMessageBox(string text, string caption, AppMessageBoxButton button,
                                                            AppMessageBoxImage image, AppMessageBoxResult defaultResult);

        protected virtual void OnRaiseProjectSettingsChanged(EventArgs e)
        {
            this.ProjectSettingsChanged?.Invoke(this, e);
        }

        internal void RaiseProjectSettingsChanged()
        {
            this.OnRaiseProjectSettingsChanged(EventArgs.Empty);
        }
    }
}
