﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Diagnostics;
    using System.IO;
    using System.Linq;
    using System.Text.RegularExpressions;
    using System.Windows.Forms;

    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.SoundFoundation.Core.Resources;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.SoundFoundation.Parameters;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.Resources;

    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    [CommandKeyProcessable]
    public partial class FindWindow : Form
    {
        private static int WM_QUERYENDSESSION = 0x11;
        private bool systemShutDown = false;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public FindWindow()
        {
            InitializeComponent();

            this.findPanel_Item.TargetDocumentKind = FindArgs.TargetDocumentKinds.SoundSet;
            this.findPanel_Inst.TargetDocumentKind = FindArgs.TargetDocumentKinds.Bank;

            UpdateAcceptButton();
        }

        /// <summary>
        ///
        /// </summary>
        private MainWindow MainWindow
        {
            get { return FormsApplication.Instance.UIService.MainWindow; }
        }

        /// <summary>
        ///
        /// </summary>
        public void UpdateInnerData()
        {
            this.findPanel_Item.UpdateInnerData();
            this.findPanel_Inst.UpdateInnerData();
        }

#if false
        /// <summary>
        ///
        /// </summary>
        public Component[] FindAllFromProject( string name)
        {
            Component[] components = this.findPanel_Item.FindAllFromProject( name);
            if (components.Length == 0)
            {
                components = this.findPanel_Inst.FindAllFromProject( name);
            }
            return components;
        }
#endif

        /// <summary>
        /// ウインドウプロシージャ
        /// </summary>
        protected override void WndProc(ref Message m)
        {
            if (m.Msg == WM_QUERYENDSESSION)
            {
                this.systemShutDown = true;
            }

            base.WndProc(ref m);
        }

        /// <summary>
        ///
        /// </summary>
        protected override void OnClosing(System.ComponentModel.CancelEventArgs e)
        {
            if (this.systemShutDown == false)
            {
                Hide();
                MainWindow.BuildCommandUI();

                e.Cancel = true;
            }
        }

        /// <summary>
        ///
        /// </summary>
        protected override void OnActivated(EventArgs e)
        {
            base.OnActivated(e);
            FindPanel findPanel = GetActiveFindPanel();
            findPanel.SelectFindText();
        }

        /// <summary>
        ///
        /// </summary>
        protected override void OnDeactivate(EventArgs e)
        {
            base.OnDeactivate(e);
        }

        /// <summary>
        /// ウインドウの位置が変更された時に呼ばれる
        /// </summary>
        private void OnMove(object sender, System.EventArgs e)
        {
            //WindowStatus.SetBounds( WindowState, Bounds);
        }

        /// <summary>
        /// ウインドウのサイズが変更された時に呼ばれる
        /// </summary>
        private void OnResize(object sender, System.EventArgs e)
        {
            //WindowStatus.SetBounds( WindowState, Bounds);
        }

        /// <summary>
        ///
        /// </summary>
        private void OnSelectedIndexChanged(object sender, EventArgs e)
        {
            UpdateAcceptButton();
        }

        /// <summary>
        ///
        /// </summary>
        private void UpdateAcceptButton()
        {
            FindPanel findPanel = GetActiveFindPanel();
            AcceptButton = findPanel != null ? findPanel.button_FindNext : null;
        }

        /// <summary>
        ///
        /// </summary>
        private FindPanel GetActiveFindPanel()
        {
            TabPage tabPage = this.tabControl.SelectedTab;
            foreach (Control control in tabPage.Controls)
            {
                if (control is FindPanel)
                {
                    return control as FindPanel;
                }
            }
            return null;
        }
    }
}
