﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.Configurations.Schemas;
    using NintendoWare.SoundMaker.Framework.Preset;
    using NintendoWare.SoundMaker.Framework.Resources;

    public static class ListHeaderHelper
    {
        public static void AddPresetListColumns(string listName, ListConfigurationApplier applier)
        {
            PresetListColumnsNameSettingDialog dialog = new PresetListColumnsNameSettingDialog();
            dialog.Text = MessageResource.Label_AddPresetListColumns;
            show:
            if (dialog.ShowDialog() == DialogResult.OK)
            {
                PresetListColumnsService preset = ApplicationBase.Instance.PresetListColumnsService;
                if (preset.Contains(listName, dialog.PresetName) == true)
                {
                    MessageBox.Show(MessageResource.Label_WarningSameNamePresetListColumns);
                    goto show;
                }
                XmlList xmlList = new XmlList();
                xmlList.Name = listName;
                xmlList.ListColumns = new XmlListColumns();
                xmlList.ListColumns.ListColumn = new XmlListColumn[0];
                applier.Extract(xmlList);
                preset.Add(listName, dialog.PresetName, xmlList.DeepClone());
            }
        }

        public static void ApplyPresetListColumns(ListConfigurationApplier applier, string listName, string presetName)
        {
            PresetListColumnsService preset = ApplicationBase.Instance.PresetListColumnsService;
            XmlList xmlList = preset.GetListColumn(listName, presetName);
            applier.Apply(xmlList);
        }

        public static void ApplyPresetListColumnsWithoutAdd(ListConfigurationApplier applier, string listName, string presetName)
        {
            PresetListColumnsService preset = ApplicationBase.Instance.PresetListColumnsService;
            XmlList xmlList = preset.GetListColumn(listName, presetName);
            applier.ApplyWithout(xmlList);
        }

        public static void CreateMeunApplyPresetListColumns(ToolStripMenuItem applyMenu, string listName, EventHandler onClick)
        {
            applyMenu.DropDownItems.Clear();
            PresetListColumnsService preset = ApplicationBase.Instance.PresetListColumnsService;
            foreach (string presetName in preset.GetPresetNames(listName))
            {
                ToolStripMenuItem menuItem = new ToolStripMenuItem(presetName);
                menuItem.Click += onClick;
                applyMenu.DropDownItems.Add(menuItem);
            }
            applyMenu.Enabled = applyMenu.DropDownItems.Count > 0;
        }
    }
}
