﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    public class WaveOpenFileDialog
    {
        private const string DefaultExtension =
            "*.wav|*.aif|*.aiff|*.*";
        private const string DefaultFilter =
            "Wave Files (*.wav;*.aif;*.aiff)|*.wav;*.aif;*.aiff|All Files (*.*)|*.*";

        private WavePreviewControl control = null;
        private ExtendableOpenFileDialog dialog = null;

        /// <summary>
        ///
        /// </summary>
        public WaveOpenFileDialog()
        {
            Extension = DefaultExtension;
            Filter = DefaultFilter;
            FilePath = String.Empty;
            ValidatePreviewFilePathDelegate = null;
        }

        /// <summary>
        ///
        /// </summary>
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        ///
        /// </summary>
        public string Extension
        {
            get;
            set;
        }

        /// <summary>
        ///
        /// </summary>
        public string Filter
        {
            get;
            set;
        }

        /// <summary>
        ///
        /// </summary>
        public string InitialDirectory
        {
            get;
            set;
        }

        /// <summary>
        ///
        /// </summary>
        public WavePreviewControl.ValidatePreviewFilePathDelegate ValidatePreviewFilePathDelegate
        {
            get;
            set;
        }

        /// <summary>
        ///
        /// </summary>
        public string FilePath
        {
            get;
            set;
        }

        /// <summary>
        ///
        /// </summary>
        public Control Owner
        {
            get;
            set;
        }

        /// <summary>
        ///
        /// </summary>
        public void Dispose()
        {
            this.control.DisposeAllSounds();
        }

        /// <summary>
        ///
        /// </summary>
        public DialogResult ShowDialog()
        {
            this.control = new WavePreviewControl(this.ValidatePreviewFilePathDelegate);
            this.dialog = new ExtendableOpenFileDialog
                (Title, Extension, FilePath, Filter, InitialDirectory, this.control);
            this.dialog.Owner = Owner;
            this.dialog.SelectChanged += OnSelectChanged;

            DialogResult result = (this.dialog.Show() != false ?
                                    DialogResult.OK :
                                    DialogResult.Cancel);

            FilePath = this.dialog.FilePath;

            return result;
        }

        /// <summary>
        ///
        /// </summary>
        private void OnSelectChanged(string filePath)
        {
            this.control.SetFilePath(filePath);
        }
    }
}
