﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;


namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    ///--------------------------------------------------------------------------
    /// <summary>
    /// LumpsumEditDialog の概要の説明です。
    /// </summary>
    public partial class BatchEditDialog : System.Windows.Forms.Form
    {
        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public BatchEditDialog()
        {
            InitializeComponent();

            textBox_Text.MouseWheel += new MouseEventHandler(OnMouseWheel);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public string ValueText
        {
            get { return textBox_Text.Text; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public EffectKind EffectKind
        {
            get
            {
                if (radioButton_Add.Checked != false) { return EffectKind.Addition; }
                if (radioButton_Mul.Checked != false) { return EffectKind.Multiplication; }
                return EffectKind.Set;
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnCheckedChanged(object sender, EventArgs e)
        {
            if (radioButton_Set.Checked != false) { textBox_Text.Text = String.Empty; }
            if (radioButton_Add.Checked != false) { textBox_Text.Text = "0"; }
            if (radioButton_Mul.Checked != false) { textBox_Text.Text = "1.0"; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private object GetModifiedIntegerValue(string text, int delta)
        {
            int relativeValue = delta / 120;
            int value = 0;

            value = int.Parse(text);
            value += (1 * relativeValue);
            return value;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private object GetModifiedDecimalValue(string text, int delta)
        {
            double relativeValue = delta / 120;
            double value = 0;

            value = double.Parse(text);
            value += (0.1 * relativeValue);
            return value;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnMouseWheel(object sender, MouseEventArgs e)
        {
            object value = null;

            try
            {
                if (radioButton_Add.Checked != false)
                {
                    value = GetModifiedIntegerValue(textBox_Text.Text, e.Delta);
                    textBox_Text.Text = value.ToString();
                }

                if (radioButton_Mul.Checked != false)
                {
                    value = GetModifiedDecimalValue(textBox_Text.Text, e.Delta);
                    textBox_Text.Text = value.ToString();
                }
            }

            catch { }
        }
    }

    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public enum EffectKind
    {
        Set,
        Addition,
        Multiplication,
    }
}
