﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using NintendoWare.SoundFoundation.Conversion;
    using NintendoWare.SoundFoundation.Logs;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.Configurations.Schemas;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.ToolDevelopmentKit;
    using ComponentModel = System.ComponentModel;
    using Conversion = NintendoWare.SoundFoundation.Conversion;
    using Win32 = NintendoWare.SoundFoundation.Core.Win32;

    public partial class ConvertPartsDialog : Form
    {
        private const int ErrorIconIndex = 0;
        private const int ConvertingIconBegin = 1;
        private const int ConvertingIconEnd = ConvertingIconBegin + ConvertingIconCount - 1;
        private const int ConvertingIconCount = 8;
        private const int SucceededIconIndex = 9;

        ///
        private ISoundProjectConvertService convertService = null;

        private System.Windows.Forms.Timer iconTimer = new System.Windows.Forms.Timer();
        private Icon[] icons = null;
        private int convertingIconIndex = 0;

        /// <summary>
        ///
        /// </summary>
        public ConvertPartsDialog(ISoundProjectConvertService convertService)
        {
            InitializeComponent();

            //
            this.icons = new Icon[] { ImageResource.IconConvert,
                                      ImageResource.IconConverting00,
                                      ImageResource.IconConverting01,
                                      ImageResource.IconConverting02,
                                      ImageResource.IconConverting03,
                                      ImageResource.IconConverting04,
                                      ImageResource.IconConverting05,
                                      ImageResource.IconConverting06,
                                      ImageResource.IconConverting07,
                                      ImageResource.IconConvertSucceeded };
            SetIcon(ErrorIconIndex);

            //
            this.convertService = convertService;
            this.convertService.EndConvert += OnEndConvert;
            this.convertService.OutputLine += OnOutputLine;
        }

        /// <summary>
        ///
        /// </summary>
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            this.iconTimer.Interval = 200;
            this.iconTimer.Tick += OnIconTimer;
            this.iconTimer.Start();
        }

        /// <summary>
        ///
        /// </summary>
        protected override void OnFormClosing(FormClosingEventArgs e)
        {
            if (this.convertService.IsConverting != false)
            {
                e.Cancel = true;
                return;
            }

            base.OnFormClosing(e);
        }

        /// <summary>
        ///
        /// </summary>
        protected override void OnFormClosed(FormClosedEventArgs e)
        {
            this.iconTimer.Dispose();
            this.iconTimer = null;

            //
            this.convertService.OutputLine -= OnOutputLine;
            this.convertService.EndConvert -= OnEndConvert;

            base.OnFormClosed(e);
        }

        /// <summary>
        ///
        /// </summary>
        private OutputLine SelectedLine
        {
            get
            {
                if (1 != this.logText.SelectedItems.Length) { return null; }
                return this.logText.SelectedItems[0].UserData as OutputLine;
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void SetIcon(int index)
        {
            if (this.icons.Length <= index)
            {
                return;
            }

            Icon = this.icons[index];
        }

        /// <summary>
        ///
        /// </summary>
        private void UpdateIcon()
        {
            if (this.convertService.IsConverting == false)
            {
                return;
            }

            this.convertingIconIndex++;

            if (this.convertingIconIndex > ConvertingIconEnd)
            {
                this.convertingIconIndex = ConvertingIconBegin;
            }

            SetIcon(this.convertingIconIndex);
        }

        /// <summary>
        ///
        /// </summary>
        private void OnIconTimer(object sender, EventArgs e)
        {
            BeginInvoke(new MethodInvoker(UpdateIcon));
        }

        /// <summary>
        ///
        /// </summary>
        private void OnOutputLine(object sender, OutputLineEventArgs e)
        {
            AppendLine(e.Lines);

            if (null == SelectedLine &&
                e.Lines[e.Lines.Length - 1].Level == OutputLevel.Error)
            {
                this.logText.SelectLastItem();
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void OnEndConvert(object sender, Conversion.SoundProjectConvertEventArgs e)
        {
            if (e.Succeeded || e.Canceled)
            {
                ConvertFinish();
            }
            else
            {
                ConvertError();
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void AppendLine(string msg)
        {
            this.logText.Append(msg);
            this.logText.ScrollToBottom();
        }

        /// <summary>
        ///
        /// </summary>
        private void AppendLine(IEnumerable<OutputLine> lines)
        {
            foreach (OutputLine line in lines)
            {
                this.logText.Append(line.Text, line);
            }

            this.logText.ScrollToBottom();
        }

        /// <summary>
        ///
        /// </summary>
        private void ConvertFinish()
        {
            this.iconTimer.Stop();
            SetIcon(SucceededIconIndex);

            //_result = DialogResult.OK;
            DialogResult = DialogResult.OK;
        }

        /// <summary>
        ///
        /// </summary>
        private void ConvertError()
        {
#if false
            _result = DialogResult.Cancel;

            _iconTimer.Stop();
            SetIcon(ErrorIconIndex);

            buttonClose.DialogResult = DialogResult.Cancel;
            buttonClose.Enabled = true;
            buttonClose.Visible = true;

            buttonCancel.Visible = false;
            buttonCancel.Enabled = false;

            UpdateButtons();
#endif

            buttonClose.DialogResult = DialogResult.Cancel;
            buttonClose.Enabled = true;
            buttonClose.Visible = true;
        }
    }
}
