﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using NintendoWare.SoundFoundation.Core.Parameters;

    public class FloatLabelParameterValue : FloatParameterValue
    {
        private Dictionary<float, string> labelDictionary = new Dictionary<float, string>();

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public FloatLabelParameterValue()
            : base()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="value">パラメータの値を指定します。</param>
        public FloatLabelParameterValue(float value)
            : base(value)
        {
        }

        /// <summary>
        /// float の値に対応するラベルの辞書です。
        /// </summary>
        public Dictionary<float, string> LabelDictionary
        {
            get { return this.labelDictionary; }
        }

        public override string ToString()
        {
            if (this.labelDictionary.ContainsKey(this.Value) == true)
            {
                return this.labelDictionary[this.Value];
            }
            else
            {
                return base.ToString();
            }
        }

        protected override float ParseInternal(string text)
        {
            foreach (var pair in this.labelDictionary)
            {
                if (pair.Value == text)
                {
                    return pair.Key;
                }
            }

            return base.ParseInternal(text);
        }
    }
}
