﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Drawing;
    using System.Drawing.Imaging;
    using System.IO;
    using System.Linq;
    using System.Security.Cryptography;
    using System.Windows.Forms;
    using System.Windows.Forms.VisualStyles;
    using NintendoWare.SoundFoundation.CommandHandlers;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate;
    using NintendoWare.SoundFoundation.FileFormats.Wave;
    using NintendoWare.SoundFoundation.Operations;
    using NintendoWare.SoundFoundation.Parameters;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.CommandHandlers;
    using NintendoWare.SoundMaker.Framework.Configurations;
    using NintendoWare.SoundMaker.Framework.Configurations.Schemas;
    using NintendoWare.SoundMaker.Framework.FileFormats;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.ToolDevelopmentKit.Collections;

    /// <summary>
    /// 行ヘッダ
    /// </summary>
    public class ListSubItemCommonRowHeader : ListPartParameter, IListSubItem
    {
        private static ListPart[] _Parts = new[] {
            new ListPart( "RowHeader", String.Empty,
                          ( ListPartActions.ItemSelectable |
                            ListPartActions.ItemDragable   |
                            ListPartActions.DoubleClickable )),
        };

        /// <summary>
        ///
        /// </summary>
        string IListSubItem.Name
        {
            get { return "RowHeader"; }
        }

        /// <summary>
        ///
        /// </summary>
        IListPart[] IListSubItem.GetParts(ListDrawDescriptor desc)
        {
            return _Parts;
        }

        /// <summary>
        ///
        /// </summary>
        string IListSubItem.RepresentativeEditorName(bool immediateEdit)
        {
            return null;
        }

        /// <summary>
        ///
        /// </summary>
        bool IListSubItem.EditByKey
        {
            get { return false; }
        }
    }

    /// <summary>
    /// ユーザーパラメータ
    /// </summary>
    public class ListSubItemUserData : ListPartParameter, IListSubItem
    {
        private static ListPart _Part = null;

        /// <summary>
        ///
        /// </summary>
        static ListSubItemUserData()
        {
            //_Part = new ListPart("ULong", "ULong", "UserDataEditDialog",
            _Part = new ListPart("UserParameter", "ULong", "UserDataEditDialog",
                                  DefaultPartAction);
        }

        /// <summary>
        ///
        /// </summary>
        public ListSubItemUserData()
        {
            PartParameters["Text"] = "...";
        }

        /// <summary>
        ///
        /// </summary>
        string IListSubItem.Name
        {
            get { return "UserData"; }
        }

        /// <summary>
        ///
        /// </summary>
        bool IListSubItem.EditByKey
        {
            get { return true; }
        }

        /// <summary>
        ///
        /// </summary>
        IListPart[] IListSubItem.GetParts(ListDrawDescriptor desc)
        {
            if (desc.Selected == false)
            { //||
                //!( desc.Parameter is FilePathParameterValue )) {
                return new[] { _Part };
            }

            ListPart part0 = null;
            ListPart part1 = null;
            Rectangle bounds = new Rectangle();
            int width = 16;
            int height = 16;
            int y = (desc.Bounds.Height - height) / 2;

            //
            bounds.X = desc.Bounds.Width - width;
            bounds.Y = y;
            bounds.Width = width;
            bounds.Height = height;

            part0 = new ListPart("Button", "UserDataEditDialog", null, bounds,
                                  ListPartActions.EditByClick);

            //
            bounds.X = 0;
            bounds.Y = 0;
            bounds.Width = desc.Bounds.Width - width;
            bounds.Height = desc.Bounds.Height;

            //part1 = new ListPart("ULong", "ULong", "UserDataEditDialog",
            part1 = new ListPart("UserParameter", "ULong", "UserDataEditDialog",
                                  bounds, DefaultPartAction);

            //
            return new[] { part0, part1 };
        }

        /// <summary>
        ///
        /// </summary>
        string IListSubItem.RepresentativeEditorName(bool immediateEdit)
        {
            return immediateEdit != false ? "ULong" : "UserDataEditDialog";
        }

        /// <summary>
        ///
        /// </summary>
        protected static ListPartActions DefaultPartAction
        {
            get { return (ListPartActions.EditByDoubleClick); }
        }
    }

    /// <summary>
    /// ユーザーパラメータ（整数）
    /// </summary>
    public class ListSubItemUserParameterInteger : ListSubItemInteger
    {
        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ListSubItemUserParameterInteger()
        {
            this.Parts = new[] {
                new ListPart( "UserParameterInteger", "Integer", DefaultPartAction),
            };
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override string Name
        {
            get { return "UserParameterInteger"; }
        }
    }

    /// <summary>
    /// ユーザーパラメータ（符号無し整数）
    /// </summary>
    public class ListSubItemUserParameterULong : ListSubItemULong
    {
        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ListSubItemUserParameterULong()
        {
            this.Parts = new[] {
                new ListPart( "UserParameterULong", "ULong", DefaultPartAction),
            };
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override string Name
        {
            get { return "UserParameterULong"; }
        }
    }

    /// <summary>
    /// ユーザーパラメータ（少数）
    /// </summary>
    public class ListSubItemUserParameterFloat : ListSubItemFloat
    {
        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ListSubItemUserParameterFloat()
        {
            this.Parts = new[] {
                new ListPart( "UserParameterFloat", "Float", DefaultPartAction),
            };
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override string Name
        {
            get { return "UserParameterFloat"; }
        }
    }

    /// <summary>
    /// ユーザーパラメータ（Boolean）
    /// </summary>
    public class ListSubItemUserParameterBoolean : ListSubItemCheckBox
    {
        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ListSubItemUserParameterBoolean()
        {
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override string Name
        {
            get { return "UserParameterBoolean"; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override IListPart[] GetPartsInternal(ListDrawDescriptor desc)
        {
            ListPart part0 = null;
            ListPart part1 = null;
            Rectangle bounds = new Rectangle();
            int width = desc.Bounds.Width < 16 ? desc.Bounds.Width : 16;
            int height = desc.Bounds.Height < 16 ? desc.Bounds.Height : 16;
            int x = (desc.Bounds.Width - width) / 2;
            int y = (desc.Bounds.Height - height) / 2;

            bounds.X = x;
            bounds.Y = y;
            bounds.Width = width;
            bounds.Height = height;

            part0 = new ListPart("UserParameterBoolean", "CheckBox", null, bounds,
                                  (ListPartActions.EditByClick |
                                    ListPartActions.EditByClickOnCaret));

            part1 = new ListPart("Blank", "CheckBox", null, Rectangle.Empty,
                                 ListPartActions.EditByDoubleClick);

            return new[] { part0, part1 };
        }
    }

    /// <summary>
    /// ユーザーパラメータ（AssistDropDown）
    /// </summary>
    public class ListSubItemUserParameterAssistDropDown : ListSubItemAssistDropDown
    {
        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ListSubItemUserParameterAssistDropDown()
        {
            this.Parts = new[] {
                new ListPart( "UserParameterAssistDropDown", "AssistDropDown", DefaultPartAction),
            };
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override string Name
        {
            get { return "UserParameterAssistDropDown"; }
        }
    }

    /// <summary>
    /// プレビュー再生ボタン
    /// </summary>
    public class ListSubItemPreviewPlay : ListPartParameter, IListSubItem
    {
        /// <summary>
        ///
        /// </summary>
        string IListSubItem.Name
        {
            //get { return "PreviewPlay"; }
            get { return GetName(); }
        }

        /// <summary>
        ///
        /// </summary>
        bool IListSubItem.EditByKey
        {
            get { return true; }
        }

        /// <summary>
        ///
        /// </summary>
        IListPart[] IListSubItem.GetParts(ListDrawDescriptor desc)
        {
            ListPart part0 = null;
            ListPart part1 = null;
            Rectangle bounds = new Rectangle();

            int width = desc.Bounds.Width < 20 ? desc.Bounds.Width : 20;
            int height = desc.Bounds.Height < 17 ? desc.Bounds.Height : 17;
            int x = (desc.Bounds.Width - width) / 2;
            int y = (desc.Bounds.Height - height) / 2;

            bounds.X = x;
            bounds.Y = y;
            bounds.Width = width;
            bounds.Height = height;

            part0 = new ListPart("PreviewPlay", "PreviewPlay", null, bounds,
                                (ListPartActions.EditByClick |
                                 ListPartActions.EditByClickOnCaret));

            //
            bounds = Rectangle.Empty;
            part1 = new ListPart("Blank", "PreviewPlay", null, bounds,
                                 ListPartActions.EditByDoubleClick);

            //
            return new[] { part0, part1 };
        }

        /// <summary>
        ///
        /// </summary>
        string IListSubItem.RepresentativeEditorName(bool immediateEdit)
        {
            return "PreviewPlay";
        }

        /// <summary>
        ///
        /// </summary>
        protected virtual string GetName()
        {
            return "PreviewPlay";
        }
    }

    /// <summary>
    /// ミュートボタン
    /// </summary>
    public class ListSubItemPreviewMute : ListPartParameter, IListSubItem
    {
        /// <summary>
        ///
        /// </summary>
        string IListSubItem.Name
        {
            get { return "PreviewMute"; }
        }

        /// <summary>
        ///
        /// </summary>
        bool IListSubItem.EditByKey
        {
            get { return true; }
        }

        /// <summary>
        ///
        /// </summary>
        IListPart[] IListSubItem.GetParts(ListDrawDescriptor desc)
        {
            ListPart part0 = null;
            ListPart part1 = null;
            Rectangle bounds = new Rectangle();

            int width = desc.Bounds.Width < 20 ? desc.Bounds.Width : 20;
            int height = desc.Bounds.Height < 17 ? desc.Bounds.Height : 17;
            int x = (desc.Bounds.Width - width) / 2;
            int y = (desc.Bounds.Height - height) / 2;

            bounds.X = x;
            bounds.Y = y;
            bounds.Width = width;
            bounds.Height = height;

            part0 = new ListPart("PreviewMute", "PreviewMute", null, bounds,
                                  (ListPartActions.EditByClick |
                                   ListPartActions.EditByClickOnCaret));

            //
            bounds = Rectangle.Empty;
            part1 = new ListPart("Blank", "PreviewMute", null, bounds,
                                  ListPartActions.EditByDoubleClick);

            //
            return new[] { part0, part1 };
        }

        /// <summary>
        ///
        /// </summary>
        string IListSubItem.RepresentativeEditorName(bool immediateEdit)
        {
            return "PreviewMute";
        }
    }

    /// <summary>
    /// ソロ再生ボタン
    /// </summary>
    public class ListSubItemPreviewSoloPlay : ListPartParameter, IListSubItem
    {
        /// <summary>
        ///
        /// </summary>
        string IListSubItem.Name
        {
            get { return "PreviewSoloPlay"; }
        }

        /// <summary>
        ///
        /// </summary>
        bool IListSubItem.EditByKey
        {
            get { return true; }
        }

        /// <summary>
        ///
        /// </summary>
        IListPart[] IListSubItem.GetParts(ListDrawDescriptor desc)
        {
            ListPart part0 = null;
            ListPart part1 = null;
            Rectangle bounds = new Rectangle();

            int width = desc.Bounds.Width < 20 ? desc.Bounds.Width : 20;
            int height = desc.Bounds.Height < 17 ? desc.Bounds.Height : 17;
            int x = (desc.Bounds.Width - width) / 2;
            int y = (desc.Bounds.Height - height) / 2;

            bounds.X = x;
            bounds.Y = y;
            bounds.Width = width;
            bounds.Height = height;

            part0 = new ListPart("PreviewSoloPlay", "PreviewSoloPlay", null, bounds,
                                  (ListPartActions.EditByClick |
                                   ListPartActions.EditByClickOnCaret));

            //
            bounds = Rectangle.Empty;
            part1 = new ListPart("Blank", "PreviewSoloPlay", null, bounds,
                                  ListPartActions.EditByDoubleClick);

            //
            return new[] { part0, part1 };
        }

        /// <summary>
        ///
        /// </summary>
        string IListSubItem.RepresentativeEditorName(bool immediateEdit)
        {
            return "PreviewSoloPlay";
        }
    }

    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public class NameParameterValue : TextParameterValue
    {
        /// <summary>
        ///
        /// </summary>
        public NameParameterValue(string text)
            : base(text)
        {
        }

        /// <summary>
        ///
        /// </summary>
        private SoundProjectService ProjectService
        {
            get { return FormsApplication.Instance.ProjectService; }
        }

        /// <summary>
        ///
        /// </summary>
        protected override ValidationResult ValidateInternal(string value)
        {
            if (value == null) { return new ValidationResult(false); }

            ValidationResult result = null;
            string name = (string)value;

            result = ItemNameValidator.ValidateSoundProjectItemName(name);
            if (result.IsValid == false)
            {
                return result;
            }

            //
            if (ProjectService.ComponentDictionary.Contains(name) != false)
            {
                Component[] components = ProjectService.ComponentDictionary[name]
                    .Where(c => !(c is SoundSet))
                    .Where(c => !(c is FolderComponent))
                    .Where(c => !(c is SoundProject))
                    .ToArray();

                if (components.Length > 0)
                {
                    return new ValidationResult
                        (false, MessageResource.Message_ItemNameAlreadyExisting);
                }
            }

            return ValidationResult.NoError;
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class TextWithNAParameterValue : TextParameterValue
    {
        private bool available = true;

        /// <summary>
        ///
        /// </summary>
        public TextWithNAParameterValue(string text, bool available)
            : base(text)
        {
            this.available = available;
        }

        /// <summary>
        ///
        /// </summary>
        public bool Available
        {
            get
            {
                return this.available;
            }
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class GroupItemDropDownListItem : IParameterValue
    {
        private Component _TargetComponent = null;
        private IParameterValue _TargetParameter = null;
        //private object          _Value = null;

        public event ParameterEventHandler ValueChanged;

        /// <summary>
        ///
        /// </summary>
        public GroupItemDropDownListItem(Component targetComponent, IParameterValue targetParameter)
        {
            _TargetParameter = targetParameter;
            _TargetComponent = targetComponent;
        }

        public Component Component
        {
            get { return _TargetComponent; }
        }

        /// <summary>
        /// パラメータの属性コレクションを取得します。
        /// </summary>
        public ICollection<object> Attributes
        {
            get
            {
                return _TargetParameter.Attributes;
            }
        }

        /// <summary>
        /// パラメータキーを含めたパラメータのハッシュコードを取得します。
        /// </summary>
        /// <param name="algorithm">ハッシュアルゴリズムを指定します。</param>
        /// <param name="key">パラメータキーを指定します。</param>
        /// <param name="filter">対象パラメータのフィルタを指定します。</param>
        /// <returns>ハッシュコードを返します。</returns>
        public HashCode GetParameterHashCode(HashAlgorithm algorithm, string key, Func<IParameterValue, bool> filter)
        {
            return _TargetParameter.GetParameterHashCode(algorithm, key, filter);
        }

        /// <summary>
        ///
        /// </summary>
        public override string ToString()
        {
            return _TargetParameter.ToString();
        }

        /// <summary>
        ///
        /// </summary>
        public void Parse(string text)
        {
            _TargetParameter.Parse(text);
        }

        /// <summary>
        ///
        /// </summary>
        public virtual object ParseValue(string text)
        {
            return _TargetParameter.ParseValue(text);
        }

        /// <summary>
        ///
        /// </summary>
        public ValidationResult Validate()
        {
            return _TargetParameter.Validate();
        }

        /// <summary>
        ///
        /// </summary>
        public virtual ValidationResult ValidateValue(object value)
        {
            return _TargetParameter.ValidateValue(value);
        }

        /// <summary>
        ///
        /// </summary>
        public virtual object Value
        {
            get { return _TargetParameter.Value; }
            set { _TargetParameter.Value = value; }
        }

        /// <summary>
        ///
        /// </summary>
        protected void OnValueChanged()
        {
            if (ValueChanged != null)
            {
                ValueChanged(this, new ParameterEventArgs(string.Empty, this));
            }
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class ListSubItemDropDownList : ListPartParameter, IListSubItem
    {
        private ListPart[] _Parts = null;
        private string _Name = null;
        private string _EditorName = null;

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ListSubItemDropDownList() : this("DropDownList", "DropDownList")
        {
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ListSubItemDropDownList(string name, string editorName)
        {
            _Name = name;
            _EditorName = editorName;
            _Parts = new[] { new ListPart("Text", editorName, DefaultPartAction), };
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        string IListSubItem.Name
        {
            get { return _Name; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        IListPart[] IListSubItem.GetParts(ListDrawDescriptor desc)
        {
            return _Parts;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        string IListSubItem.RepresentativeEditorName(bool immediateEdit)
        {
            return _EditorName;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        bool IListSubItem.EditByKey
        {
            get { return true; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected static ListPartActions DefaultPartAction
        {
            get
            {
                return (ListPartActions.EditByDoubleClick |
                         ListPartActions.EditByClickOnCaret);
            }
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class ListSubItemBankAssistDropDown : ListPartParameter, IListSubItem
    {
        private static ListPart[] Parts = null;

        /// <summary>
        ///
        /// </summary>
        static ListSubItemBankAssistDropDown()
        {
            Parts = new[] {
                new ListPart( "Text", "AssistDropDown", DefaultPartAction),
                //new ListPart( "Button", "BankDialog", DefaultPartAction),
            };
        }

        /// <summary>
        ///
        /// </summary>
        public ListSubItemBankAssistDropDown()
        {
            PartParameters["Text"] = "...";
        }

        /// <summary>
        ///
        /// </summary>
        string IListSubItem.Name
        {
            get { return "BankAssistDropDown"; }
        }

        /// <summary>
        ///
        /// </summary>
        IListPart[] IListSubItem.GetParts(ListDrawDescriptor desc)
        {
            if (desc.Selected == false)
            {
                return Parts;
            }

            if (desc.Item is ImaginaryInstrumentListItem)
            {
                return Parts;
            }

            //
            ListPart part0 = null;
#if false
            ListPart part1 = null;
#endif
            Rectangle bounds = new Rectangle();
            int width = 16;
            int height = 16;
            int y = (desc.Bounds.Height - height) / 2;

            //
            bounds.X = 0;
            bounds.Y = 0;
            bounds.Width = desc.Bounds.Width - width;
            bounds.Height = desc.Bounds.Height;

            part0 = new ListPart("Text", "AssistDropDown", null, bounds,
                                 DefaultPartAction);

#if false
            //
            bounds.X = desc.Bounds.Width - width;
            bounds.Y = y;
            bounds.Width  = width;
            bounds.Height = height;

            part1 = new ListPart( "Button", "BankDialog", null,
                                  bounds, ListPartActions.EditByClick);
#endif

            //
            //return new[] { part0, part1 };
            return new[] { part0 };
        }

        /// <summary>
        ///
        /// </summary>
        string IListSubItem.RepresentativeEditorName(bool immediateEdit)
        {
            return "DropDown";
        }

        /// <summary>
        ///
        /// </summary>
        bool IListSubItem.EditByKey
        {
            get { return true; }
        }

        /// <summary>
        ///
        /// </summary>
        protected static ListPartActions DefaultPartAction
        {
            get
            {
                return (ListPartActions.EditByDoubleClick |
                         ListPartActions.EditByClickOnCaret);
            }
        }
    }
}
