﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Drawing;
    using System.Drawing.Imaging;
    using System.IO;
    using System.Linq;
    using System.Security.Cryptography;
    using System.Windows.Forms;
    using System.Windows.Forms.VisualStyles;
    using NintendoWare.SoundFoundation.CommandHandlers;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate;
    using NintendoWare.SoundFoundation.FileFormats.Wave;
    using NintendoWare.SoundFoundation.Operations;
    using NintendoWare.SoundFoundation.Parameters;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.CommandHandlers;
    using NintendoWare.SoundMaker.Framework.Configurations;
    using NintendoWare.SoundMaker.Framework.Configurations.Schemas;
    using NintendoWare.SoundMaker.Framework.FileFormats;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.ToolDevelopmentKit.Collections;

    /// <summary>
    /// グループアイテム用ドロップダウンリスト
    /// </summary>
    public class GroupItemDropDownList : AssistDropDownInplaceEditor
    {
        private Dictionary<string, GroupItemDropDownListItem> _Dictionary = null;

        /// <summary>
        ///
        /// </summary>
        public void OnDrawItem(object sender, DrawItemEventArgs e)
        {
            if (this.Disposing == true)
            {
                return;
            }

            ComboBox comboBox = sender as ComboBox;
            GroupItemDropDownListItem item = null;

            string text = null;
            Component component = null;

            text = comboBox.Items[e.Index] as string;
            if (_Dictionary.ContainsKey(text) != false)
            {
                item = _Dictionary[text];
                component = item.Component;
                text = item.ToString();
            }

            ListPartCommonRowHeaderDrawer.DrawItem(e, comboBox.Font, component, text);
        }

        /// <summary>
        ///
        /// </summary>
        protected override ComboBox CreateControl()
        {
            _Dictionary = new Dictionary<string, GroupItemDropDownListItem>();
            foreach (GroupItemDropDownListItem item in Values)
            {
                var key = item.ToString();

                if (_Dictionary.ContainsKey(key))
                {
                    continue;
                }

                _Dictionary.Add(key, item);
            }

            //
            ComboBox comboBox = new InplaceEditor.InplaceComboBox();
            comboBox.DrawMode = DrawMode.OwnerDrawFixed;
            comboBox.DrawItem += OnDrawItem;
            return comboBox;
        }
    }

    /// <summary>
    /// ユーザーデータ設定ダイアログ
    /// </summary>
    public class UserDataEditDialogInplaceEditor : InplaceEditor
    {
        private ulong userDataValue;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public UserDataEditDialogInplaceEditor()
            : base(false)
        {
        }

        /// <summary>
        ///
        /// </summary>
        public override bool CanImmediateEdit
        {
            get { return false; }
        }

        /// <summary>
        ///
        /// </summary>
        public override object GetValue()
        {
            return userDataValue;
        }

        ///--------------------------------
        /// <summary>
        /// 編集が行われたのか調べる
        /// </summary>
        public override bool Modified
        {
            get
            {
                return userDataValue != (ulong)InitialValue.Value;
            }
        }

        /// <summary>
        ///
        /// </summary>
        protected override bool BeginEditInternal(Rectangle rect, string text, bool readOnly)
        {
            //
            ExecuteEventBeginEditing();

            //
            UserParameterStructureSetting setting = GetUserDataStructureSettingByName(TargetName);
            string title = GetUserDataTextByName(TargetName);

            var initialValue = (ulong)InitialValue.Value;
            this.userDataValue = initialValue;

            if (setting.Structures.Count <= 0)
            {
                var dialog = new UserDataEditDialog();
                dialog.Value = initialValue;
                dialog.Text = title;
                if (dialog.ShowDialog() == DialogResult.OK)
                {
                    this.userDataValue = dialog.Value;
                    return true;
                }
            }
            else
            {
                var dialog2 = new UserDataEditDialog2();
                dialog2.Value = initialValue;
                dialog2.UserDataStructureSetting = setting;
                dialog2.Text = title;
                if (dialog2.ShowDialog() == DialogResult.OK)
                {
                    this.userDataValue = dialog2.Value;
                    return true;
                }
            }

            return false;
        }

        /// <summary>
        ///
        /// </summary>
        public UserParameterStructureSettings UserDataStructureSettings { get; set; }

        /// <summary>
        ///
        /// </summary>
        private int GetIndexByName(string name)
        {
            switch (name)
            {
                case "UserParameter":
                    return 0;
                case "UserParameter1":
                    return 1;
                case "UserParameter2":
                    return 2;
                case "UserParameter3":
                    return 3;
                default:
                    Debug.Assert(false, "Bad parameter name");
                    return -1;
            }
        }

        /// <summary>
        ///
        /// </summary>
        private UserParameterStructureSetting GetUserDataStructureSettingByName(string name)
        {
            return UserDataStructureSettings.Settings[GetIndexByName(name)];
        }

        /// <summary>
        ///
        /// </summary>
        private string GetUserDataTextByName(string name)
        {
            string[] texts = new string[]
                {
                    MessageResource.HeaderText_UserParameter,
                    MessageResource.HeaderText_UserParameter1,
                    MessageResource.HeaderText_UserParameter2,
                    MessageResource.HeaderText_UserParameter3,
                };
            return texts[GetIndexByName(name)];
        }
    }

    /// <summary>
    /// プレビュー再生ボタン
    /// </summary>
    public class PreviewPlayInplaceEditor : InplaceEditor
    {
        private bool _Value = false;

        /// <summary>
        ///
        /// </summary>
        public PreviewPlayInplaceEditor()
            : base(false)
        {
        }

        /// <summary>
        ///
        /// </summary>
        public override bool CanImmediateEdit
        {
            get { return false; }
        }

        /// <summary>
        ///
        /// </summary>
        public override object GetValue()
        {
            return _Value;
        }

        ///--------------------------------
        /// <summary>
        /// 編集が行われたのか調べる
        /// </summary>
        public override bool Modified
        {
            get
            {
                return true; // 再生ボタンなのでクリックしたら常に true を返す。
            }
        }

        /// <summary>
        /// 編集の開始
        /// </summary>
        protected override bool BeginEditInternal(Rectangle rect, string text, bool readOnly)
        {
            return true; // 読み取り専用でも再生する。
        }
    }

    /// <summary>
    /// ミュートボタン
    /// </summary>
    public class PreviewMuteInplaceEditor : PreviewPlayInplaceEditor
    {
    }

    /// <summary>
    /// ソロ再生ボタン
    /// </summary>
    public class PreviewSoloPlayInplaceEditor : PreviewPlayInplaceEditor
    {
    }

    /// <summary>
    /// マルチバンク設定ダイアログ
    /// </summary>
    public class MultipleBankEditDialogInplaceEditor : InplaceEditor
    {
        public System.ComponentModel.CancelEventHandler Execute { get; set; }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public MultipleBankEditDialogInplaceEditor()
            : base(false)
        {
            RequireInitialValue = false;
        }

        /// <summary>
        ///
        /// </summary>
        public override bool CanImmediateEdit
        {
            get { return false; }
        }

        /// <summary>
        ///
        /// </summary>
        public override object GetValue()
        {
            return null;
        }

        /// <summary>
        ///
        /// </summary>
        protected override bool BeginEditInternal(Rectangle rect, string text, bool readOnly)
        {
            ExecuteEventBeginEditing();

            if (Execute != null)
            {
                System.ComponentModel.CancelEventArgs args = new System.ComponentModel.CancelEventArgs();
                Execute(this, args);
                if (args.Cancel == true)
                {
                    return false;
                }
            }

            return true;
        }
    }
}
