﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

///
namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Windows.Forms;

    using NintendoWare.SoundFoundation.Windows.Forms;

    /// <summary>
    /// ヘッダアダプタの基本クラス
    /// </summary>
    public abstract class ListHeaderAdapterBase : ComponentHeaderAdapter
    {
        private HeaderColumnData[] _HeaderColumns;

        public HeaderColumnData[] Columns
        {
            get { return _HeaderColumns; }
            set
            {
                if (value == _HeaderColumns) { return; }
                SetupColumns(value);
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected abstract void SetRowHeaderColumn();

        ///--------------------------------
        /// <summary>
        /// カラムの設定
        /// </summary>
        protected void SetupColumns(HeaderColumnData[] datas)
        {
            _HeaderColumns = datas;
            ClearColumns();

            if (null != datas)
            {
                SetRowHeaderColumn();
                SetColumns(datas);
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void ClearColumns()
        {
            Items.Clear();
        }

        ///--------------------------------
        /// <summary>
        /// カラムの設定
        /// </summary>
        private void SetColumns(HeaderColumnData[] datas)
        {
            ComponentHeaderItem item = null;

            foreach (HeaderColumnData data in datas)
            {
                item = new ComponentHeaderItem(data.Name);
                item.Text = data.Text;
                item.Length = data.Length;
                item.MinimumLength = data.MinimumLength;
                item.MaximumLength = data.MaximumLength;
                item.Alignment = data.Alignment;
                item.Visible = data.Visible;
                Items.Add(item);
            }
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class HeaderColumnData : ICloneable
    {
        public string Name { get; set; }
        public string Text { get; set; }
        public int Length { get; set; }
        public int MinimumLength { get; set; }
        public int MaximumLength { get; set; }
        public HorizontalAlignment Alignment { get; set; }
        public bool Visible { get; set; }

        /// <summary>
        ///
        /// </summary>
        public HeaderColumnData()
        {
            MinimumLength = 0;
            MaximumLength = int.MaxValue;
        }

        /// <summary>
        ///
        /// </summary>
        object ICloneable.Clone()
        {
            HeaderColumnData data = new HeaderColumnData();
            data.Name = Name;
            data.Text = Text;
            data.Length = Length;
            data.MinimumLength = MinimumLength;
            data.MaximumLength = MaximumLength;
            data.Alignment = Alignment;
            data.Visible = Visible;
            return data;
        }

        /// <summary>
        ///
        /// </summary>
        public HeaderColumnData Clone()
        {
            return ((ICloneable)this).Clone() as HeaderColumnData;
        }
    }
}
