﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Linq;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Commands;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.Commands;
using NintendoWare.SoundMaker.Framework.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.CommandHandlers
{
    /// <summary>
    /// 新しいストリームサウンドを作成します。
    /// </summary>
    public class QueryAndAddStreamSoundHandler : AddSoundHandler
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="queryTarget">対象の問い合わせ先。</param>
        /// <param name="defaultPlayerName">デフォルトプレイヤー名。</param>
        public QueryAndAddStreamSoundHandler(bool insert, IQueryCommandParameter queryParameter,
                                              string defaultPlayerName)
            : base(insert ? ProjectCommands.InsertStreamSound.ID : ProjectCommands.AddStreamSound.ID,
                    insert, queryParameter, defaultPlayerName)
        { }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        /// <returns>実行した場合は true、実行しなかった、キャンセルした場合は false。</returns>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            var soundSetDocument = GetTargetDocument(parameters);
            CreateStreamSoundDialog form = new CreateStreamSoundDialog(Application.ProjectService, soundSetDocument, DefaultPlayerName);
            if (form.ShowDialog() != DialogResult.OK) { return false; }

            if (!Execute(parameters, form.NewSound)) { return false; }

            (Application.UIService as FormsUIService).MainWindow.ShowPageByComponent(form.NewSound);
            return true;
        }

        /// <summary>
        /// アイテムの追加先を取得します。
        /// </summary>
        /// <param name="queryTarget">対象の問い合わせ先。</param>
        /// <returns>アイテムの追加先。</returns>
        protected override Component GetInsertParentComponent(IQueryCommandParameter queryParameter)
        {
            SoundSetDocument targetDocument = GetTargetDocument(queryParameter);
            if (null == targetDocument) { return null; }

            return (from Component component in targetDocument.SoundSet.Children
                    where component is StreamSoundPack
                    select component as StreamSoundPack).FirstOrDefault();
        }
    }
}
