﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Commands;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.Commands;
using NintendoWare.SoundMaker.Framework.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.CommandHandlers
{
    /// <summary>
    /// 新しいグループを作成します。
    /// </summary>
    public class InstrumentListQueryAndAddInstrumentHandler : AddBankItemHandler
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="insert">挿入する場合は false、追加する場合は false。</param>
        /// <param name="queryTarget">対象の問い合わせ先。</param>
        public InstrumentListQueryAndAddInstrumentHandler(bool insert, IQueryCommandParameter queryParameter)
            : base(insert ? InstrumentListCommands.InsertInstrument.ID : InstrumentListCommands.AddInstrument.ID,
                    insert, queryParameter)
        { }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        /// <returns>実行した場合は true、実行しなかった、キャンセルした場合は false。</returns>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            CreateInstrumentDialog form = new CreateInstrumentDialog(Application.ProjectService,
                                                                  GetTargetComponentService(parameters) as BankService);
            if (form.ShowDialog() != DialogResult.OK) { return false; }

            if (!Execute(parameters, form.Instrument)) { return false; }

            (Application.UIService as FormsUIService).MainWindow.ShowPageByComponent(form.Instrument);
            return true;
        }

        /// <summary>
        /// アイテムの追加先を取得します。
        /// </summary>
        /// <param name="queryTarget">対象の問い合わせ先。</param>
        /// <returns>アイテムの追加先。</returns>
        protected override Component GetInsertParentComponent(IQueryCommandParameter queryParameter)
        {
            if (null == queryParameter) { throw new ArgumentNullException("queryParameter"); }

            BankDocument targetDocument = GetTargetDocument(queryParameter);
            if (null == targetDocument) { return null; }

            return targetDocument.Bank;
        }
    }
}
