﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms.CommandHandlers
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.CommandHandlers;
    using NintendoWare.SoundMaker.Framework.Commands;

    ///--------------------------------------------------------------------------
    /// <summary>
    /// "ブックマークに追加"ハンドラ
    /// </summary>

    public class AddBookmarkHandler : EditCommandHandler
    {
        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public AddBookmarkHandler(IQueryCommandParameter queryParameter)
            : base(EditCommands.AddBookmark.ID, queryParameter)
        {
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            Component[] components = GetTargetComponents(parameters);

            ApplicationBase.Instance.BookmarkService.Add(components[0]);

            return true;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override CommandStatus QueryStatusInternal(Command command, IQueryCommandParameter parameters)
        {
            CommandStatus result = base.QueryStatusInternal(command, parameters);

            if (result == CommandStatus.SupportedAndEnabledAndVisible)
            {
                Component[] components = GetTargetComponents(parameters);

                if (components.Length != 1)
                {
                    result = CommandStatus.SupportedAndVisible;
                }
                else
                {
                    if (components[0] is SoundSet == true ||
                        components[0] is SoundProject == true ||
                        components[0] is FolderComponent == true)
                    {
                        result = CommandStatus.SupportedAndVisible;
                    }
                    else
                    {
                        result = CommandStatus.SupportedAndEnabledAndVisible;
                    }
                }
            }

            return result;
        }
    }
}
