﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Utilities
{
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.Windows.Forms;
    using System.Collections.Generic;
    using System.Linq;

    public static class AddonSoundArchiveUtility
    {
        public static bool IsItemInAddonSoundArchive(Component component)
        {
            var soundSet = GetSoundSet(component);
            if (soundSet != null)
            {
                return IsAddonSoundSet(soundSet);
            }
            return false;
        }

        public static IEnumerable<SoundSet> GetMainSoundSets()
        {
            return ProjectService.SoundSets
                .Where(s => IsAddonSoundSet(s) == false);
        }

        public static SoundArchiveOutputTypes GetSoundArchiveOutputType(Component component)
        {
            var soundSet = GetSoundSet(component);
            if (soundSet != null)
            {
                SoundArchiveOutputTypes outputType;
                if (ProjectService.Project.SoundArchiveOutputTypes.TryGetValue(soundSet, out outputType) == true)
                {
                    return outputType;
                }
            }
            return SoundArchiveOutputTypes.SoundArchive;
        }

        private static SoundProjectService ProjectService
        {
            get
            {
                return FormsApplication.Instance.ProjectService;
            }
        }

        private static bool IsAddonSoundSet(SoundSet soundSet)
        {
            SoundArchiveOutputTypes outputType;
            if (ProjectService.Project.SoundArchiveOutputTypes.TryGetValue(soundSet, out outputType) == true)
            {
                return outputType == SoundArchiveOutputTypes.AddonSoundArchive;
            }
            return false;
        }

        private static SoundSet GetSoundSet(Component component)
        {
            while (component != null)
            {
                if (component is SoundSet)
                {
                    return component as SoundSet;
                }

                component = component.Parent;
            }
            return null;
        }
    }
}
