﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Net;
using System.Runtime.InteropServices;

/*

    ==========================================================================
    ※このプロトコルヘッダは、
    $(NW4R_ROOT)/ToolUtil/ProtocolUtil/Protocol/ProtocolSound/ProtocolSound.xml
    から自動生成されて作られたものです。
    プロトコルを編集する際には、.h及び.csファイルを直接編集するのではなく
    ProtocolSound.xmlファイルを編集し再コンバートする必要があります。
    ==========================================================================

    Viewer - SoundMaker通信プロトコル

    通信メッセージの種類
        ビューアメッセージ  ビューアからエディタに送るメッセージ
        エディタメッセージ  エディタからビューアに送るメッセージ
        エラーメッセージ    エラーが起こった際に送るメッセージ

    通信の際には必ずMessageHeaderを送信し、その次にMessageDataを送信します。
    MessageHeaderは2byteのMessageTypeと2byteのMessageSizeからなります。

    +---------------------------+--------------------+
    |      MessageHeader        |    MessageData     |
    +-------------+-------------+                    |
    | MessageType | MessageSize | (MessageSize byte) |
    | (2byte)     | (2byte)     |                    |
    +-------------+-------------+--------------------+

    MessageTypeは1bitのErrorFlag、1bitのReplyFlag、6bitのCategory
    8bitのCommandからなります。

    15             8 7             0
    +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
    |E|R| Category  |    Command    |
    +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
    Errorがtrueの時にはReplyは必ずfalseになります。
 */
namespace NW4R.ProtocolSound
{
    using NintendoWare.SoundMaker.Framework.Preview.Communications;
    using NintendoWare.SoundFoundation.Projects;

#if false
    //-----------------------------------------------------------------------
    /** <summary>Constants</summary> */
    public class Constants{

        //-------------------------------------------------------------------
        /*
            バージョン情報の定義
            バージョン番号の運用は各モジュールとツールでの運用ルールにあわせてください
         */
        /** <summary>プロトコルバージョン</summary> */
        public const uint	PROTOCOL_VERSION =	0x00010002;

        //-------------------------------------------------------------------
        /* メッセージのフラグとマスクの定義 */
        /** <summary>エラー用フラグ        </summary> */
        public const ushort	HEADER_ERROR_FLAG =	0x8000;
        /** <summary>要返信メッセージフラグ</summary> */
        public const ushort	HEADER_REPLY_FLAG =	0x4000;
        /** <summary>カテゴリ用マスク      </summary> */
        public const ushort	HEADER_CATEGORY_MASK =	0x3F00;
        /** <summary>コマンド用マスク      </summary> */
        public const ushort	HEADER_COMMAND_MASK =	0x00FF;

        //-------------------------------------------------------------------
        /*
            カテゴリの定義
         */
        /** <summary>システム関連カテゴリ </summary> */
        public const ushort	CATEGORY_SYSTEM =	0x0000;
        /** <summary>3Dモデル関連カテゴリ </summary> */
        public const ushort	CATEGORY_3D =	0x0100;
        /** <summary>サウンド関連カテゴリ </summary> */
        public const ushort	CATEGORY_SOUND =	0x0300;
        /** <summary>MCS通信テストカテゴリ</summary> */
        public const ushort	CATEGORY_TEST =	0x3F00;

        //-------------------------------------------------------------------
        /* システム関連カテゴリのメッセージ */
        /** <summary>バージョン要求コマンド</summary> */
        public const ushort	TOOL_SYSTEM_VERSION =	0x00 + CATEGORY_SYSTEM + HEADER_REPLY_FLAG;
        /** <summary>同期用コマンド</summary> */
        public const ushort	TOOL_SYSTEM_SYNC =	0x01 + CATEGORY_SYSTEM + HEADER_REPLY_FLAG;
        /** <summary>モジュールリセットコマンド</summary> */
        public const ushort	TOOL_SYSTEM_RESET =	0x02 + CATEGORY_SYSTEM;

        //-------------------------------------------------------------------
        /* 3Dモデル関連カテゴリのメッセージ */
        /** <summary>モデルデータの読み込みコマンド</summary> */
        public const ushort	TOOL_3D_LOAD_MODEL =	0x00 + CATEGORY_3D + HEADER_REPLY_FLAG;
        /** <summary>ロードされているモデルリスト取得コマンド</summary> */
        public const ushort	TOOL_3D_GET_MODEL_LIST =	0x01 + CATEGORY_3D + HEADER_REPLY_FLAG;
        /** <summary>モデルのノードリスト取得コマンド</summary> */
        public const ushort	TOOL_3D_GET_NODE_LIST =	0x02 + CATEGORY_3D + HEADER_REPLY_FLAG;

        //-------------------------------------------------------------------
        /* サウンド関連カテゴリのメッセージ */
        /** <summary>サウンドシステム関連メッセージ範囲</summary> */
        public const ushort	TOOL_SOUND_SYSTEMBEGIN =	0x00 + CATEGORY_SOUND;
        /** <summary>サウンドシステム関連メッセージ範囲</summary> */
        public const ushort	TOOL_SOUND_SYSTEMEND =	0x39 + CATEGORY_SOUND;
        /** <summary>サウンドモードへの強制切り替えコマンド</summary> */
    public const ushort	TOOL_SOUND_FOCUS =	0x01 + CATEGORY_SOUND;
        /** <summary>エコーコマンド</summary> */
        public const ushort	TOOL_SOUND_ECHO =	0x02 + CATEGORY_SOUND + HEADER_REPLY_FLAG;
        /** <summary>全発音停止</summary> */
        public const ushort	TOOL_SOUND_ALLSTOP =	0x03 + CATEGORY_SOUND;
        /** <summary>サウンドシステム設定</summary> */
        public const ushort	TOOL_SOUND_SET_SYSTEMPARAMETERS =	0x04 + CATEGORY_SOUND;

        /** <summary>サウンド関連メッセージ範囲</summary> */
        public const ushort	TOOL_SOUND_SOUNDBEGIN =	0x40 + CATEGORY_SOUND;
        /** <summary>サウンド関連メッセージ範囲</summary> */
        public const ushort	TOOL_SOUND_SOUNDEND =	0x79 + CATEGORY_SOUND;
        /** <summary>サウンドアーカイブの読み込みコマンド</summary> */
        public const ushort	TOOL_SOUND_LOADSAR =	0x41 + CATEGORY_SOUND + HEADER_REPLY_FLAG;
        /** <summary>サウンドラベルの設定</summary> */
        public const ushort	TOOL_SOUND_SET_SOUNDLABELS =	0x42 + CATEGORY_SOUND;
        /** <summary>サウンド状態の取得</summary> */
        public const ushort	TOOL_SOUND_GET_SOUNDINFORMATIONS =	0x43 + CATEGORY_SOUND;
        /** <summary>サウンド情報の表示</summary> */
        public const ushort	TOOL_SOUND_SHOWSOUNDINFORMATION =	0x44 + CATEGORY_SOUND;
        /** <summary>再生コマンド</summary> */
        public const ushort	TOOL_SOUND_PLAY =	0x45 + CATEGORY_SOUND;
        /** <summary>一時停止コマンド</summary> */
        public const ushort	TOOL_SOUND_PAUSE =	0x46 + CATEGORY_SOUND;
        /** <summary>停止コマンド</summary> */
        public const ushort	TOOL_SOUND_STOP =	0x47 + CATEGORY_SOUND;
        /** <summary>エフェクトパラメータの転送 PC→Viewer</summary> */
        public const ushort	TOOL_SOUND_SET_EFFECTPARAMETERS =	0x48 + CATEGORY_SOUND;
        /** <summary>エフェクトパラメータの転送 PC←Viewer</summary> */
        public const ushort	TOOL_SOUND_GET_EFFECTPARAMETERS =	0x49 + CATEGORY_SOUND + HEADER_REPLY_FLAG;
        /** <summary>シーケンス変数の転送 PC→Viewer</summary> */
        public const ushort	TOOL_SOUND_SET_SEQVARIABLES =	0x50 + CATEGORY_SOUND;
        /** <summary>シーケンス変数の転送 PC←Viewer</summary> */
        public const ushort	TOOL_SOUND_GET_SEQVARIABLES =	0x51 + CATEGORY_SOUND;
        /** <summary>プレビュープレイヤーパラメータの転送 PC→Viewer</summary> */
        public const ushort	TOOL_SOUND_SET_PREVIEWPLAYERPARAMETER =	0x52 + CATEGORY_SOUND;

      /** <summary>サウンドアーカイブファイルを閉じる</summary> */
      public const ushort	TOOL_SOUND_CLOSESAR =	0x53 + CATEGORY_SOUND + HEADER_REPLY_FLAG;

      //-------------------------------------------------------------------
        /** <summary>アニメーションサウンド関連メッセージ範囲</summary> */
        public const ushort	TOOL_SOUND_ANIM_SOUNDBEGIN =	0x80 + CATEGORY_SOUND;
        /** <summary>アニメーションサウンド関連メッセージ範囲</summary> */
        public const ushort	TOOL_SOUND_ANIM_SOUNDEND =	0xB9 + CATEGORY_SOUND;
        /** <summary>3Dモデルデータの読み込みコマンド</summary> */
        public const ushort	TOOL_SOUND_ANIM_LOAD3DMODEL =	0x81 + CATEGORY_SOUND + HEADER_REPLY_FLAG;
        /** <summary>アニメーションデータの読み込みコマンド</summary> */
        public const ushort	TOOL_SOUND_ANIM_LOADANIMATION =	0x82 + CATEGORY_SOUND + HEADER_REPLY_FLAG;
        /** <summary>アニメーションサウンドデータの読み込みコマンド</summary> */
        public const ushort	TOOL_SOUND_ANIM_LOADANIMSOUND =	0x83 + CATEGORY_SOUND + HEADER_REPLY_FLAG;
        /** <summary>アニメーションキャッシュの破棄コマンド</summary> */
        public const ushort	TOOL_SOUND_ANIM_DISPOSECACHE =	0x84 + CATEGORY_SOUND + HEADER_REPLY_FLAG;
        /** <summary>アクティブアニメーションの切り替え</summary> */
        public const ushort	TOOL_SOUND_ANIM_ACTIVATEANIMATION =	0x85 + CATEGORY_SOUND + HEADER_REPLY_FLAG;
        /** <summary>アニメーションフレーム取得コマンド</summary> */
        public const ushort	TOOL_SOUND_ANIM_QUERYFRAME =	0x86 + CATEGORY_SOUND + HEADER_REPLY_FLAG;
        /** <summary>アニメーションフレーム設定コマンド</summary> */
        public const ushort	TOOL_SOUND_ANIM_SETFRAME =	0x87 + CATEGORY_SOUND + HEADER_REPLY_FLAG;
        /** <summary>アニメーション再生</summary> */
        public const ushort	TOOL_SOUND_ANIM_PLAY =	0x88 + CATEGORY_SOUND;
        /** <summary>アニメーション停止</summary> */
        public const ushort	TOOL_SOUND_ANIM_STOP =	0x89 + CATEGORY_SOUND;
        /** <summary>アニメーション再生レート設定コマンド</summary> */
        public const ushort	TOOL_SOUND_ANIM_SETRATE =	0x90 + CATEGORY_SOUND;
        /** <summary>ループ状態設定コマンド</summary> */
        public const ushort	TOOL_SOUND_ANIM_SETLOOP =	0x91 + CATEGORY_SOUND;
        /** <summary>アニメーション再生範囲設定コマンド</summary> */
        public const ushort	TOOL_SOUND_ANIM_SETRANGE =	0x92 + CATEGORY_SOUND + HEADER_REPLY_FLAG;
        /** <summary>アニメーションサウンドのイベント更新コマンド</summary> */
        public const ushort	TOOL_SOUND_ANIM_MODIFIEREVENT =	0x93 + CATEGORY_SOUND;

        //-------------------------------------------------------------------
        /* テストカテゴリのメッセージ */
        /** <summary>EFBカラー変更コマンド</summary> */
        public const ushort	TOOL_TEST_EFB_COLOR =	0x00 + CATEGORY_TEST;

        //-------------------------------------------------------------------
        /* ビューア主導 システム関連カテゴリのメッセージ */
        /** <summary>ビューア主導のテストコマンド</summary> */
        public const ushort	VIEWER_TEST_NOP =	0x00 + CATEGORY_TEST;

        //-------------------------------------------------------------------
        /* システムエラーカテゴリのメッセージ */
        /** <summary>未定義コマンドエラー</summary> */
        public const ushort	ERR_SYSTEM_UNKNOWN_COMMAND =	0x0 + CATEGORY_SYSTEM + HEADER_ERROR_FLAG;

        //-------------------------------------------------------------------
        /* データエラーカテゴリのメッセージ */
        /** <summary>データロードエラー        </summary> */
        public const ushort	ERR_3D_LOAD =	0x0 + CATEGORY_3D + HEADER_ERROR_FLAG;

        //-------------------------------------------------------------------
        /* サウンドカテゴリのメッセージ */
        /** <summary>サウンドエラー</summary> */
        public const ushort	ERR_SOUND =	0x0 + CATEGORY_SOUND + HEADER_ERROR_FLAG;

        //-------------------------------------------------------------------
        /* エラーコード用フラグの定義 */
        /** <summary>エラーフラグ</summary> */
        public const uint	MCSSOUND_ERRORFLAG =	0x80000000;

        //-------------------------------------------------------------------
        /* エラーコード用カテゴリの定義 */
        /** <summary>一般</summary> */
        public const uint	MCSSOUNDCATEGORY_GENERAL =	0x00000000;
        /** <summary>サウンド</summary> */
        public const uint	MCSSOUNDCATEGORY_SOUND =	0x00010000;
        /** <summary>アニメーションサウンド</summary> */
        public const uint	MCSSOUNDCATEGORY_ANIMSOUND =	0x00020000;

        //-------------------------------------------------------------------
        /* サウンドエラーコード */
        /** <summary>成功。</summary> */
        public const uint	MCSSOUND_S_OK =	0x0000;
        /** <summary>エラーが発生しました。        </summary> */
        public const uint	MCSSOUND_E_FAILED =	0x0000 + MCSSOUNDCATEGORY_GENERAL + MCSSOUND_ERRORFLAG;
        /** <summary>ファイルが見つかりません。    </summary> */
        public const uint	MCSSOUND_E_FILENOTFOUND =	0x0001 + MCSSOUNDCATEGORY_GENERAL + MCSSOUND_ERRORFLAG;
        /** <summary>メモリが不足しています。      </summary> */
        public const uint	MCSSOUND_E_OUTOFMEMORY =	0x0002 + MCSSOUNDCATEGORY_GENERAL + MCSSOUND_ERRORFLAG;
        /** <summary>無効なデータです。            </summary> */
        public const uint	MCSSOUND_E_INVALIDDATA =	0x0003 + MCSSOUNDCATEGORY_GENERAL + MCSSOUND_ERRORFLAG;
        /** <summary>MCS通信で異常が発生しました。 </summary> */
        public const uint	MCSSOUND_E_TRANSFERFAILED =	0x0004 + MCSSOUNDCATEGORY_GENERAL + MCSSOUND_ERRORFLAG;
        /** <summary>無効なアニメーションIDです。      </summary> */
        public const uint	MCSSOUND_E_ANIM_INVALIDCOMPONENTID =	0x0001 + MCSSOUNDCATEGORY_ANIMSOUND + MCSSOUND_ERRORFLAG;
        /** <summary>モデルキャッシュが見つかりません。</summary> */
        public const uint	MCSSOUND_E_ANIM_MODELCACHENOTFOUND =	0x0002 + MCSSOUNDCATEGORY_ANIMSOUND + MCSSOUND_ERRORFLAG;
        /** <summary>アクションキャッシュが見つかりません。</summary> */
        public const uint	MCSSOUND_E_ANIM_ACTIONCACHENOTFOUND =	0x0003 + MCSSOUNDCATEGORY_ANIMSOUND + MCSSOUND_ERRORFLAG;

    }


    //-----------------------------------------------------------------------
    /** <summary>Soundプロトコルのメッセージ共通ヘッダ</summary> */
    public class Header {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0+2+2;
        /** <summary>メッセージタイプ   </summary> */
        public ushort	type;
        /** <summary>メッセージサイズ   </summary> */
        public ushort	size;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader){
            type = reader.ReadUInt16();
            size = reader.ReadUInt16();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer){
            writer.Write(type);
            writer.Write(size);
        }

    }
#endif

    //-----------------------------------------------------------------------
    /** <summary>
         バージョン要求応答メッセージ
            ツールのプロトコルバージョンを受け取り、ビューアのプロトコルバージョンを返します。
        </summary> */
    public class ToolSystemVersion
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>4B: バージョン番号</summary> */
        public uint version;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            version = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(version);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
        同期メッセージ

              Viewerは、この同期コマンドを受け取ると、指定されたtagName
              名をエコーした応答コマンドをアプリケーションに返信します。

              tagNameは､ツール側が自由に設定できます。
        </summary> */
    public class ToolSystemSync
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>4B: タグ名</summary> */
        public uint tagName;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            tagName = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(tagName);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            モデルデータの読み込みメッセージ

            fileSizeが0の場合には、そのモデルIDを持つデータの破棄とみなします。

            ロードに成功した場合にはTool3DLoadModelReplyを成功応答メッセージとして返します。
            失敗した場合には、ER_DATA_LOADコマンドを返します。
        </summary> */
    public class Tool3DLoadModel
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 1 * 260;
        /** <summary>  4B: ファイルサイズ       </summary> */
        public uint fileSize;
        /** <summary>260B: PC上のデータのパス名 </summary> */
        public byte[] pathName = new byte[260];

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            fileSize = reader.ReadUInt32();
            for (int i = 0; i < 260; i++)
            {
                pathName[i] = reader.ReadByte();
            }
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(fileSize);
            writer.Write(pathName);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            モデルデータの読み込み応答メッセージ
        </summary> */
    public class Tool3DLoadModelReply
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>  4B: ロードされたモデルの管理ID  </summary> */
        public uint id;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            id = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(id);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            ロードされているモデルリスト応答メッセージ
            この後にsize個のモデルIDが続く可変長の応答メッセージです。
        </summary> */
    public class Tool3DGetModelListReply
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>                4B: Viewerにロードされているモデルの数           </summary> */
        public uint modelCount;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            modelCount = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(modelCount);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            モデルリストの要素構造体
        </summary> */
    public class Tool3DGetModelListReplyElement
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4;
        /** <summary>          4B: モデルの管理ID              </summary> */
        public uint id;
        /** <summary>          4B: モデル名の文字列長(NUL込み) </summary> */
        public uint nameSize;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            id = reader.ReadUInt32();
            nameSize = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(id);
            writer.Write(nameSize);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            モデルのノードリスト取得メッセージ
        </summary> */
    public class Tool3DGetNodeList
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>  4B: モデルの管理ID           </summary> */
        public uint id;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            id = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(id);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            モデルのノードリスト応答メッセージ
            モデルが存在しない場合にはnameLengthが0で返る
        </summary> */
    public class Tool3DGetNodeListReply
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>               4B: モデル内のノード数    </summary> */
        public int nodeCount;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            nodeCount = reader.ReadInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(nodeCount);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            ノードリストの要素構造体
        </summary> */
    public class Tool3DGetNodeListReplyElement
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4;
        /** <summary>          4B: ノードのインデックス                                 </summary> */
        public int idx;
        /** <summary>          4B: 親ノードのインデックス(ルートノードの場合には負の値) </summary> */
        public int parentIdx;
        /** <summary>          4B: ノード名の文字列長(NUL込み)                          </summary> */
        public uint nameSize;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            idx = reader.ReadInt32();
            parentIdx = reader.ReadInt32();
            nameSize = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(idx);
            writer.Write(parentIdx);
            writer.Write(nameSize);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>一括送信用アイテムコンテナ</summary> */
    public class ToolSoundItemContainer
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4;
        /** <summary>データへのオフセット</summary> */
        public uint offsetForData;
        /** <summary>アイテム数</summary> */
        public uint itemCount;
        /** <summary>1アイテムのサイズ</summary> */
        public uint itemSize;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            offsetForData = reader.ReadUInt32();
            itemCount = reader.ReadUInt32();
            itemSize = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(offsetForData);
            writer.Write(itemCount);
            writer.Write(itemSize);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>ファイル情報</summary> */
    public class ToolSoundFileInfo
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 1 * 260;
        /** <summary>260B: PC上のデータのパス名</summary> */
        public byte[] fileName = new byte[260];

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            for (int i = 0; i < 260; i++)
            {
                fileName[i] = reader.ReadByte();
            }
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(fileName);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>サウンドの状態</summary> */
    public enum ToolSoundOutputMode
    {
        /** <summary>無効値</summary> */
        OutputMode_Invalid = 0,
        /** <summary>モノラル</summary> */
        OutputMode_Monoral = 1,
        /** <summary>ステレオ</summary> */
        OutputMode_Stereo = 2,
        /** <summary>サラウンド</summary> */
        OutputMode_Surround = 3,
        /** <summary>DPL2</summary> */
        OutputMode_Dpl2 = 4,
    }

    //-----------------------------------------------------------------------
    /** <summary>サウンドアーカイブ読み込みメッセージ </summary> */
    public class ToolSoundSystemParameters
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary> 4B: 出力モード</summary> */
        public ToolSoundOutputMode outputMode;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            outputMode = (ToolSoundOutputMode)reader.ReadInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)outputMode);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>サウンドアーカイブ読み込みメッセージ </summary> */
    public class ToolSoundLoadSar
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 1 * 260;
        /** <summary>260B: PC上のデータのパス名</summary> */
        public byte[] pathName = new byte[260];

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            for (int i = 0; i < 260; i++)
            {
                pathName[i] = reader.ReadByte();
            }
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(pathName);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>サウンドアーカイブ読み込み応答メッセージ</summary> */
    public class ToolSoundLoadSarReply
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>4B: 未使用</summary> */
        public uint id;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            id = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(id);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>サウンドアーカイブを閉じる応答メッセージ</summary> */
    public class ToolSoundCloseSarReply
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>4B: 未使用</summary> */
        public uint result;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            result = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(result);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>サウンドの状態</summary> */
    public enum ToolSoundPreviewSoundState
    {
        /** <summary>サウンドが指定されていない</summary> */
        SoundState_Disabled = 0,
        /** <summary>停止中</summary> */
        SoundState_Stopped = 1,
        /** <summary>再生準備中</summary> */
        SoundState_Preparing = 2,
        /** <summary>再生中</summary> */
        SoundState_Playing = 3,
        /** <summary>一時停止中</summary> */
        SoundState_Paused = 4,
    }

    //-----------------------------------------------------------------------
    /** <summary>サウンドのラベル</summary> */
    public class ToolSoundPreviewSoundLabel
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 1 * 260;
        /** <summary>  4B: パラメータの有効フラグ（1:有効, 0:無効）</summary> */
        public uint index;
        /** <summary>260B: サウンドの名前（無効の場合は設定対象としない）</summary> */
        public byte[] label = new byte[260];

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            index = reader.ReadUInt32();
            for (int i = 0; i < 260; i++)
            {
                label[i] = reader.ReadByte();
            }
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(index);
            writer.Write(label);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>サウンドの情報</summary> */
    public class ToolSoundPreviewSoundInfomation
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>4B: サウンドの状態</summary> */
        public ToolSoundPreviewSoundState state;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            state = (ToolSoundPreviewSoundState)reader.ReadInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)state);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>プレビュープレイヤー識別子</summary> */
    public class ToolSoundPreviewPlayerID
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>4B: プレビュープレイヤーのインデックス</summary> */
        public uint index;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            index = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(index);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>バスの種類</summary> */
    public enum ToolSoundAuxBusType
    {
        /** <summary>Aux A </summary> */
        AuxBusType_AuxA = 0,
        /** <summary>Aux B </summary> */
        AuxBusType_AuxB = 1,
        /** <summary>Aux C </summary> */
        AuxBusType_AuxC = 2,
    }

    //-----------------------------------------------------------------------
    /** <summary>エフェクトの種類</summary> */
    public enum ToolSoundEffectType
    {
        /** <summary>NO EFFECT  </summary> */
        EffectType_NoEffect = 0,
        /** <summary>REVERB HI  </summary> */
        EffectType_ReverbHi = 1,
        /** <summary>REVERB STD </summary> */
        EffectType_ReverbStd = 2,
        /** <summary>CHORUS     </summary> */
        EffectType_Chorus = 3,
        /** <summary>DELAY      </summary> */
        EffectType_Delay = 4,
        /** <summary>MULTI CHANNEL REVERB</summary> */
        EffectType_MultiChannelReverb = 5,
        /** <summary>MULTI CHANNEL Chorus</summary> */
        EffectType_MultiChannelChorus = 6,
        /** <summary>MULTI CHANNEL Delay</summary> */
        EffectType_MultiChannelDelay = 7,
    }

    //-----------------------------------------------------------------------
    /** <summary>後部残響音の種類</summary> */
    public enum ToolSoundFusedMode
    {
        /** <summary>old axfx    </summary> */
        FusedMode_OldAxfx = 0,
        /** <summary>metal tank  </summary> */
        FusedMode_MetalTank = 1,
        /** <summary>small room  </summary> */
        FusedMode_SmallRoom = 2,
        /** <summary>large room  </summary> */
        FusedMode_LargeRoom = 3,
        /** <summary>hall        </summary> */
        FusedMode_Hall = 4,
        /** <summary>cavernous   </summary> */
        FusedMode_Cavernous = 5,
    }

    //-----------------------------------------------------------------------
    /** <summary></summary> */
    public enum ToolSoundEarlyMode
    {
        /** <summary>small room </summary> */
        SmallRoom = 0,
        /** <summary>large room </summary> */
        LargeRoom = 1,
        /** <summary>hall       </summary> */
        Hall = 2,
        /** <summary>cavern     </summary> */
        Cavern = 3,
        /** <summary>no early reflection </summary> */
        None = 4,
    }

    //-----------------------------------------------------------------------
    /** <summary></summary> */
    public enum ToolSoundLateMode
    {
        /** <summary>room </summary> */
        Room = 0,
        /** <summary>hall </summary> */
        Hall = 1,
        /** <summary>metal corridor</summary> */
        MetalCorridor = 2,
        /** <summary>cavern     </summary> */
        Cavern = 3,
        /** <summary>maximun reverb delay       </summary> */
        Maximun = 4,
    }

    //-----------------------------------------------------------------------
    /** <summary>各種エフェクトパラメータ共通部</summary> */
    public class ToolSoundEffectCommonParameter
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4 + 1 * 44;
        /** <summary> 4B: バスの種類</summary> */
        public ToolSoundAuxBusType busType;
        /** <summary> 4B: インデックス</summary> */
        public uint effectIndex;
        /** <summary> 4B:エフェクトの種類</summary> */
        public ToolSoundEffectType effectType;
        /** <summary>44B: reserved</summary> */
        public byte[] reserved = new byte[44];

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            busType = (ToolSoundAuxBusType)reader.ReadInt32();
            effectIndex = reader.ReadUInt32();
            effectType = (ToolSoundEffectType)reader.ReadInt32();
            for (int i = 0; i < 44; i++)
            {
                reserved[i] = reader.ReadByte();
            }
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)busType);
            writer.Write(effectIndex);
            writer.Write((int)effectType);
            writer.Write(reserved);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>NO EFFECT パラメータ</summary> */
    public class ToolSoundNoEffectParameter
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4 + 1 * 44;
        /** <summary> 4B: バスの種類</summary> */
        public ToolSoundAuxBusType busType;
        /** <summary> 4B: インデックス</summary> */
        public uint effectIndex;
        /** <summary> 4B:エフェクトの種類</summary> */
        public ToolSoundEffectType effectType;
        /** <summary>44B: reserved</summary> */
        public byte[] reserved = new byte[44];

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            busType = (ToolSoundAuxBusType)reader.ReadInt32();
            effectIndex = reader.ReadUInt32();
            effectType = (ToolSoundEffectType)reader.ReadInt32();
            for (int i = 0; i < 44; i++)
            {
                reserved[i] = reader.ReadByte();
            }
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)busType);
            writer.Write(effectIndex);
            writer.Write((int)effectType);
            writer.Write(reserved);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>REVERB HI パラメータ</summary> */
    public class ToolSoundReverbHiParameter
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4;
        /** <summary> 4B: バスの種類</summary> */
        public ToolSoundAuxBusType busType;
        /** <summary> 4B: インデックス</summary> */
        public uint effectIndex;
        /** <summary> 4B: エフェクトの種類</summary> */
        public ToolSoundEffectType effectType;
        /** <summary> 4B: early mode</summary> */
        public int earlyMode;
        /** <summary> 4B: pre delay time max</summary> */
        public float preDelayTimeMax;
        /** <summary> 4B: pre delay time</summary> */
        public float preDelayTime;
        /** <summary> 4B: fused mode</summary> */
        public ToolSoundFusedMode fusedMode;
        /** <summary> 4B: fused time</summary> */
        public float fusedTime;
        /** <summary> 4B: coloration</summary> */
        public float coloration;
        /** <summary> 4B: damping</summary> */
        public float damping;
        /** <summary> 4B: crosstalk</summary> */
        public float crosstalk;
        /** <summary> 4B: early gain</summary> */
        public float earlyGain;
        /** <summary> 4B: fused gain</summary> */
        public float fusedGain;
        /** <summary> 4B: out gain</summary> */
        public float outGain;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            busType = (ToolSoundAuxBusType)reader.ReadInt32();
            effectIndex = reader.ReadUInt32();
            effectType = (ToolSoundEffectType)reader.ReadInt32();
            earlyMode = reader.ReadInt32();
            preDelayTimeMax = reader.ReadSingle();
            preDelayTime = reader.ReadSingle();
            fusedMode = (ToolSoundFusedMode)reader.ReadInt32();
            fusedTime = reader.ReadSingle();
            coloration = reader.ReadSingle();
            damping = reader.ReadSingle();
            crosstalk = reader.ReadSingle();
            earlyGain = reader.ReadSingle();
            fusedGain = reader.ReadSingle();
            outGain = reader.ReadSingle();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)busType);
            writer.Write(effectIndex);
            writer.Write((int)effectType);
            writer.Write(earlyMode);
            writer.Write(preDelayTimeMax);
            writer.Write(preDelayTime);
            writer.Write((int)fusedMode);
            writer.Write(fusedTime);
            writer.Write(coloration);
            writer.Write(damping);
            writer.Write(crosstalk);
            writer.Write(earlyGain);
            writer.Write(fusedGain);
            writer.Write(outGain);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>REVERB STD パラメータ</summary> */
    public class ToolSoundReverbStdParameter
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 1 * 4;
        /** <summary> 4B: バスの種類</summary> */
        public ToolSoundAuxBusType busType;
        /** <summary> 4B: インデックス</summary> */
        public uint effectIndex;
        /** <summary> 4B:エフェクトの種類</summary> */
        public ToolSoundEffectType effectType;
        /** <summary> 4B: early mode</summary> */
        public int earlyMode;
        /** <summary> 4B: pre delay time max</summary> */
        public float preDelayTimeMax;
        /** <summary> 4B: pre delay time</summary> */
        public float preDelayTime;
        /** <summary> 4B: fused mode</summary> */
        public ToolSoundFusedMode fusedMode;
        /** <summary> 4B: fused time</summary> */
        public float fusedTime;
        /** <summary> 4B: coloration</summary> */
        public float coloration;
        /** <summary> 4B: damping</summary> */
        public float damping;
        /** <summary> 4B: early gain</summary> */
        public float earlyGain;
        /** <summary> 4B: fused gain</summary> */
        public float fusedGain;
        /** <summary> 4B: out gain</summary> */
        public float outGain;
        /** <summary> 4B: reserved</summary> */
        public byte[] reserved = new byte[4];

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            busType = (ToolSoundAuxBusType)reader.ReadInt32();
            effectIndex = reader.ReadUInt32();
            effectType = (ToolSoundEffectType)reader.ReadInt32();
            earlyMode = reader.ReadInt32();
            preDelayTimeMax = reader.ReadSingle();
            preDelayTime = reader.ReadSingle();
            fusedMode = (ToolSoundFusedMode)reader.ReadInt32();
            fusedTime = reader.ReadSingle();
            coloration = reader.ReadSingle();
            damping = reader.ReadSingle();
            earlyGain = reader.ReadSingle();
            fusedGain = reader.ReadSingle();
            outGain = reader.ReadSingle();
            for (int i = 0; i < 4; i++)
            {
                reserved[i] = reader.ReadByte();
            }
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)busType);
            writer.Write(effectIndex);
            writer.Write((int)effectType);
            writer.Write(earlyMode);
            writer.Write(preDelayTimeMax);
            writer.Write(preDelayTime);
            writer.Write((int)fusedMode);
            writer.Write(fusedTime);
            writer.Write(coloration);
            writer.Write(damping);
            writer.Write(earlyGain);
            writer.Write(fusedGain);
            writer.Write(outGain);
            writer.Write(reserved);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>CHORUS パラメータ</summary> */
    public class ToolSoundChorusParameter
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 1 * 24;
        /** <summary> 4B: バスの種類</summary> */
        public ToolSoundAuxBusType busType;
        /** <summary> 4B: インデックス</summary> */
        public uint effectIndex;
        /** <summary> 4B: エフェクトの種類</summary> */
        public ToolSoundEffectType effectType;
        /** <summary> 4B: delay time</summary> */
        public float delayTime;
        /** <summary> 4B: depth</summary> */
        public float depth;
        /** <summary> 4B: rate</summary> */
        public float rate;
        /** <summary> 4B: feedback</summary> */
        public float feedback;
        /** <summary> 4B: out gain</summary> */
        public float outGain;
        /** <summary>24B: reserved</summary> */
        public byte[] reserved = new byte[24];

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            busType = (ToolSoundAuxBusType)reader.ReadInt32();
            effectIndex = reader.ReadUInt32();
            effectType = (ToolSoundEffectType)reader.ReadInt32();
            delayTime = reader.ReadSingle();
            depth = reader.ReadSingle();
            rate = reader.ReadSingle();
            feedback = reader.ReadSingle();
            outGain = reader.ReadSingle();
            for (int i = 0; i < 24; i++)
            {
                reserved[i] = reader.ReadByte();
            }
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)busType);
            writer.Write(effectIndex);
            writer.Write((int)effectType);
            writer.Write(delayTime);
            writer.Write(depth);
            writer.Write(rate);
            writer.Write(feedback);
            writer.Write(outGain);
            writer.Write(reserved);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>DELAY パラメータ</summary> */
    public class ToolSoundDelayParameter
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 1 * 24;
        /** <summary> 4B: バスの種類</summary> */
        public ToolSoundAuxBusType busType;
        /** <summary> 4B: インデックス</summary> */
        public uint effectIndex;
        /** <summary> 4B: エフェクトの種類</summary> */
        public ToolSoundEffectType effectType;
        /** <summary> 4B: max delay time</summary> */
        public float maxDelayTime;
        /** <summary> 4B: delay time</summary> */
        public float delayTime;
        /** <summary> 4B: feedback</summary> */
        public float feedback;
        /** <summary> 4B: out gain</summary> */
        public float outGain;
        /** <summary> 4B: LPF</summary> */
        public float lpf;
        /** <summary>24B: reserved</summary> */
        public byte[] reserved = new byte[24];

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            busType = (ToolSoundAuxBusType)reader.ReadInt32();
            effectIndex = reader.ReadUInt32();
            effectType = (ToolSoundEffectType)reader.ReadInt32();
            maxDelayTime = reader.ReadSingle();
            delayTime = reader.ReadSingle();
            feedback = reader.ReadSingle();
            outGain = reader.ReadSingle();
            lpf = reader.ReadSingle();
            for (int i = 0; i < 24; i++)
            {
                reserved[i] = reader.ReadByte();
            }
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)busType);
            writer.Write(effectIndex);
            writer.Write((int)effectType);
            writer.Write(maxDelayTime);
            writer.Write(delayTime);
            writer.Write(feedback);
            writer.Write(outGain);
            writer.Write(lpf);
            writer.Write(reserved);
        }

    }


    //-----------------------------------------------------------------------
    /** <summary>MultiChannelReverb パラメータ</summary> */
    public class ToolSoundMultiChannelReverbParameter
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 1 * 8;
        /** <summary> 4B: バスの種類</summary> */
        public ToolSoundAuxBusType busType;
        /** <summary> 4B: インデックス</summary> */
        public uint effectIndex;
        /** <summary> 4B: エフェクトの種類</summary> */
        public ToolSoundEffectType effectType;
        /** <summary> 4B: early mode</summary> */
        public ToolSoundEarlyMode earlyMode;
        /** <summary> 4B: late mode</summary> */
        public ToolSoundLateMode lateMode;
        /** <summary> 4B: pre delay time</summary> */
        public float preDelayTime;
        /** <summary> 4B: decay time</summary> */
        public float decayTime;
        /** <summary> 4B: hf decay ratio</summary> */
        public float hfDecayRatio;
        /** <summary> 4B: coloration</summary> */
        public float coloration;
        /** <summary> 4B: early gain</summary> */
        public float earlyGain;
        /** <summary> 4B: late gain</summary> */
        public float lateGain;
        /** <summary> 4B: reverb gain</summary> */
        public float reverbGain;

        /** <summary>8B: reserved</summary> */
        public byte[] reserved = new byte[8];

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            busType = (ToolSoundAuxBusType)reader.ReadInt32();
            effectIndex = reader.ReadUInt32();
            effectType = (ToolSoundEffectType)reader.ReadInt32();
            earlyMode = (ToolSoundEarlyMode)reader.ReadInt32();
            lateMode = (ToolSoundLateMode)reader.ReadInt32();
            preDelayTime = reader.ReadSingle();
            decayTime = reader.ReadSingle();
            hfDecayRatio = reader.ReadSingle();
            coloration = reader.ReadSingle();
            earlyGain = reader.ReadSingle();
            lateGain = reader.ReadSingle();
            reverbGain = reader.ReadSingle();
            for (int i = 0; i < 8; i++)
            {
                reserved[i] = reader.ReadByte();
            }
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)busType);
            writer.Write(effectIndex);
            writer.Write((int)effectType);
            writer.Write((int)earlyMode);
            writer.Write((int)lateMode);
            writer.Write(preDelayTime);
            writer.Write(decayTime);
            writer.Write(hfDecayRatio);
            writer.Write(coloration);
            writer.Write(earlyGain);
            writer.Write(lateGain);
            writer.Write(reverbGain);
            writer.Write(reserved);
        }
    }


    //-----------------------------------------------------------------------
    /** <summary>MultiChannelReverb パラメータ</summary> */
    public class ToolSoundMultiChannelChorusParameter
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 1 * 24;
        /** <summary> 4B: バスの種類</summary> */
        public ToolSoundAuxBusType busType;
        /** <summary> 4B: インデックス</summary> */
        public uint effectIndex;
        /** <summary> 4B: エフェクトの種類</summary> */
        public ToolSoundEffectType effectType;
        /** <summary> 4B: delay time</summary> */
        public float delayTime;
        /** <summary> 4B: depth</summary> */
        public float depth;
        /** <summary> 4B: rate</summary> */
        public float rate;
        /** <summary> 4B: feedback</summary> */
        public float feedback;
        /** <summary> 4B: outGain</summary> */
        public float outGain;

        /** <summary>8B: reserved</summary> */
        public byte[] reserved = new byte[24];

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            busType = (ToolSoundAuxBusType)reader.ReadInt32();
            effectIndex = reader.ReadUInt32();
            effectType = (ToolSoundEffectType)reader.ReadInt32();
            delayTime = reader.ReadSingle();
            depth = reader.ReadSingle();
            rate = reader.ReadSingle();
            feedback = reader.ReadSingle();
            outGain = reader.ReadSingle();
            for (int i = 0; i < 24; i++)
            {
                reserved[i] = reader.ReadByte();
            }
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)busType);
            writer.Write(effectIndex);
            writer.Write((int)effectType);
            writer.Write(delayTime);
            writer.Write(depth);
            writer.Write(rate);
            writer.Write(feedback);
            writer.Write(outGain);
            writer.Write(reserved);
        }
    }

    //-----------------------------------------------------------------------
    /** <summary>MultiChannelReverb パラメータ</summary> */
    public class ToolSoundMultiChannelDelayParameter
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 1 * 24;
        /** <summary> 4B: バスの種類</summary> */
        public ToolSoundAuxBusType busType;
        /** <summary> 4B: インデックス</summary> */
        public uint effectIndex;
        /** <summary> 4B: エフェクトの種類</summary> */
        public ToolSoundEffectType effectType;
        /** <summary> 4B: delay</summary> */
        public float delay;
        /** <summary> 4B: feedback</summary> */
        public float feedback;
        /** <summary> 4B: out gain</summary> */
        public float outGain;
        /** <summary> 4B: channel spread</summary> */
        public float channelSpread;
        /** <summary> 4B: lpf</summary> */
        public float lpf;

        /** <summary>8B: reserved</summary> */
        public byte[] reserved = new byte[24];

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            busType = (ToolSoundAuxBusType)reader.ReadInt32();
            effectIndex = reader.ReadUInt32();
            effectType = (ToolSoundEffectType)reader.ReadInt32();
            delay = reader.ReadSingle();
            feedback = reader.ReadSingle();
            outGain = reader.ReadSingle();
            channelSpread = reader.ReadSingle();
            lpf = reader.ReadSingle();
            for (int i = 0; i < 24; i++)
            {
                reserved[i] = reader.ReadByte();
            }
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)busType);
            writer.Write(effectIndex);
            writer.Write((int)effectType);
            writer.Write(delay);
            writer.Write(feedback);
            writer.Write(outGain);
            writer.Write(channelSpread);
            writer.Write(lpf);
            writer.Write(reserved);
        }
    }

    //-----------------------------------------------------------------------
    /** <summary>シーケンス変数の種類</summary> */
    public enum ToolSoundSeqVariableType
    {
        /** <summary>グローバル変数</summary> */
        SeqVariableType_Global = 1,
        /** <summary>ローカル変数</summary> */
        SeqVariableType_Local = 2,
        /** <summary>トラック変数</summary> */
        SeqVariableType_Track = 3,
    }

    //-----------------------------------------------------------------------
    /** <summary>シーケンス変数コンテナヘッダ</summary> */
    public class ToolSoundSeqVariableContainerHeader
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4;
        /** <summary> 4B: シーケンス変数の種類</summary> */
        public ToolSoundSeqVariableType variableType;
        /** <summary> 4B: プレビュープレイヤーのインデックス</summary> */
        public uint previewPlayerIndex;
        /** <summary> 4B: トラック番号</summary> */
        public uint trackNo;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            variableType = (ToolSoundSeqVariableType)reader.ReadInt32();
            previewPlayerIndex = reader.ReadUInt32();
            trackNo = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)variableType);
            writer.Write(previewPlayerIndex);
            writer.Write(trackNo);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>シーケンス変数コンテナ</summary> */
    public class ToolSoundSeqVariableContainer
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + ToolSoundSeqVariableContainerHeader.StructSize + 4 * 16;
        /** <summary>12B: コンテナヘッダ</summary> */
        public ToolSoundSeqVariableContainerHeader header = new ToolSoundSeqVariableContainerHeader();
        /** <summary>64B: 変数の値（ShortMax+1 の場合、無効値）</summary> */
        public int[] variables = new int[16];

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            header.Read(reader);
            for (int i = 0; i < 16; i++)
            {
                variables[i] = reader.ReadInt32();
            }
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            header.Write(writer);
            for (int i = 0; i < 16; i++)
            {
                writer.Write(variables[i]);
            }
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>バスの種類</summary> */
    public enum ToolSoundBiquadType
    {
        /** <summary>INHERIT </summary> */
        BiquadType_Inherit = -1,
        /** <summary>OFF </summary> */
        BiquadType_Off = 0,
        /** <summary>LPF </summary> */
        BiquadType_Lpf = 1,
        /** <summary>HPF </summary> */
        BiquadType_Hpf = 2,
        /** <summary>BPF512 </summary> */
        BiquadType_Bpf512 = 3,
        /** <summary>BPF1024 </summary> */
        BiquadType_Bpf1024 = 4,
        /** <summary>BPF2048 </summary> */
        BiquadType_Bpf2048 = 5,
    }

    public static class BiquadTypeConverter
    {
        public static ToolSoundBiquadType ConvertToToolSoundBiquadType(BiquadType biquadType)
        {
            switch (biquadType)
            {
                case BiquadType.INHERIT: return ToolSoundBiquadType.BiquadType_Inherit;
                case BiquadType.None: return ToolSoundBiquadType.BiquadType_Off;
                case BiquadType.LPF: return ToolSoundBiquadType.BiquadType_Lpf;
                case BiquadType.HPF: return ToolSoundBiquadType.BiquadType_Hpf;
                case BiquadType.BPF512: return ToolSoundBiquadType.BiquadType_Bpf512;
                case BiquadType.BPF1024: return ToolSoundBiquadType.BiquadType_Bpf1024;
                case BiquadType.BPF2048: return ToolSoundBiquadType.BiquadType_Bpf2048;
            }

            return ToolSoundBiquadType.BiquadType_Off;
        }

        public static byte ConvertToByte(BiquadType biquadType)
        {
            return (byte)BiquadTypeConverter.ConvertToToolSoundBiquadType(biquadType);
        }
    }

    //-----------------------------------------------------------------------
    /** <summary>アニメーションコンポーネントの種類</summary> */
    public enum ToolSoundAnimComponentType
    {
        /** <summary>3Dモデル</summary> */
        AnimComponentType_3DModel = 1,
        /** <summary>アクション</summary> */
        AnimComponentType_Action = 2,
        /** <summary>アニメーションサウンド</summary> */
        AnimComponentType_AnimSound = 3,
    }

    //-----------------------------------------------------------------------
    /** <summary>アニメーションコンポーネント識別子</summary> */
    public class ToolSoundAnimComponentID
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4 + 4;
        /** <summary> 4B: コンポーネントの種類</summary> */
        public ToolSoundAnimComponentType type;
        /** <summary> 4B: モデルID</summary> */
        public uint modelID;
        /** <summary> 4B: アクションID（指定しない場合は -1）</summary> */
        public uint actionID;
        /** <summary> 4B: アニメーションサウンドID（指定しない場合は -1）</summary> */
        public uint animSoundID;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            type = (ToolSoundAnimComponentType)reader.ReadInt32();
            modelID = reader.ReadUInt32();
            actionID = reader.ReadUInt32();
            animSoundID = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)type);
            writer.Write(modelID);
            writer.Write(actionID);
            writer.Write(animSoundID);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>アニメーションコンポーネント追加情報</summary> */
    public class ToolSoundAnimComponentAddInfo
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + ToolSoundAnimComponentID.StructSize + 1 * 260 + 4;
        /** <summary> 16B: 対象ID</summary> */
        public ToolSoundAnimComponentID id = new ToolSoundAnimComponentID();
        /** <summary>260B: ファイル名</summary> */
        public byte[] fileName = new byte[260];
        /** <summary>  4B: キャッシュを使用しない場合は 1, キャッシュを使用する場合は 0</summary> */
        public int reload;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            id.Read(reader);
            for (int i = 0; i < 260; i++)
            {
                fileName[i] = reader.ReadByte();
            }
            reload = reader.ReadInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            id.Write(writer);
            writer.Write(fileName);
            writer.Write(reload);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            アニメーションサウンド読み込みメッセージ
        </summary> */
    public class ToolSoundLoadAsd
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 1 * 260;
        /** <summary>260B: PC上のデータのパス名</summary> */
        public byte[] pathName = new byte[260];

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            for (int i = 0; i < 260; i++)
            {
                pathName[i] = reader.ReadByte();
            }
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(pathName);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            アニメーションサウンド読み込み応答メッセージ
        </summary> */
    public class ToolSoundLoadAsdReply
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>4B: 未使用</summary> */
        public uint id;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            id = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(id);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            アニメーションフレーム設定メッセージ
        </summary> */
    public class ToolSoundAnimFrame
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4;
        /** <summary>4B: アニメーションのフレーム</summary> */
        public float frame;
        /** <summary>4B: イベントを処理するかどうか</summary> */
        public int doEvent;
        /** <summary>4B: 同期をとるかどうか</summary> */
        public int sync;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            frame = reader.ReadSingle();
            doEvent = reader.ReadInt32();
            sync = reader.ReadInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(frame);
            writer.Write(doEvent);
            writer.Write(sync);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>アニメーションフレーム設定応答メッセージ</summary> */
    public class ToolSoundAnimFrameReply
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
          0 + 4;
        /** <summary>4B: 未使用</summary> */
        public uint result;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            result = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(result);
        }
    }

    //-----------------------------------------------------------------------
    /** <summary>
            アニメーション再生レート設定メッセージ
        </summary> */
    public class ToolSoundAnimRate
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>4B: アニメーションの再生レート</summary> */
        public float rate;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            rate = reader.ReadSingle();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(rate);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            アニメーションフレーム取得応答メッセージ
        </summary> */
    public class ToolSoundQueryAnimFrameReply
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>4B: アニメーションのフレーム</summary> */
        public float frame;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            frame = reader.ReadSingle();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(frame);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            ループ状態設定メッセージ
        </summary> */
    public class ToolSoundSetLoop
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>4B: ループ状態</summary> */
        public int loopFlag;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            loopFlag = reader.ReadInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(loopFlag);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            アニメーション再生範囲設定メッセージ
        </summary> */
    public class ToolSoundAnimRange
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4;
        /** <summary>4B: ループ開始位置</summary> */
        public float start;
        /** <summary>4B: ループ終了位置</summary> */
        public float end;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            start = reader.ReadSingle();
            end = reader.ReadSingle();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(start);
            writer.Write(end);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            アニメーション再生範囲設定応答メッセージ
        </summary> */
    public class ToolSoundAnimRangeReply
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>4B: 設定変更後の現在のフレーム</summary> */
        public float frame;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            frame = reader.ReadSingle();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(frame);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            アニメーションサウンドのイベント更新コマンド
        </summary> */
    public class ToolSoundModifierEvent
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
          0 + 4 + 4 + 4 + 1 * 260 + 1 + 1 + 1 + 1 + 4 + 4 + 4 + 1 + 1 + 1 + 1 + 1 + 1;
        /** <summary>4B: 更新なら0、削除なら1</summary> */
        public int isDelete;
        /** <summary>4B: インデックス</summary> */
        public int index;
        /** <summary>4B: サウンドID</summary> */
        public uint soundId;
        /** <summary>260B: 名前</summary> */
        public byte[] soundName = new byte[260];
        /** <summary>1B: ボリューム</summary> */
        public byte volume;
        /** <summary>1B: パディング</summary> */
        public byte padding1;
        /** <summary>1B: パディング</summary> */
        public byte padding2;
        /** <summary>1B: パディング</summary> */
        public byte padding3;
        /** <summary>4B: ピッチ</summary> */
        public float pitch;
        /** <summary>4B: 開始フレーム</summary> */
        public int startFrame;
        /** <summary>4B: 終了フレーム</summary> */
        public int endFrame;
        /** <summary>1B: フレーム処理のオプションフラグ</summary> */
        public byte frameFlag;
        /** <summary>1B: 再生するループ数</summary> */
        public sbyte loopOffset;
        /** <summary>1B: loopCount以降で再生するループ間隔</summary> */
        public byte loopInterval;
        /** <summary>1B: 再生方向</summary> */
        public byte playDirection;
        /** <summary>1B: 再生速度反映用シーケンス変数</summary> */
        public byte playSpeedSequenceVariable;
        /** <summary>1B: パディング</summary> */
        public byte padding4;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            isDelete = reader.ReadInt32();
            index = reader.ReadInt32();
            soundId = reader.ReadUInt32();
            for (int i = 0; i < 260; i++)
            {
                soundName[i] = reader.ReadByte();
            }
            volume = reader.ReadByte();
            padding1 = reader.ReadByte();
            padding2 = reader.ReadByte();
            padding3 = reader.ReadByte();
            pitch = reader.ReadSingle();
            startFrame = reader.ReadInt32();
            endFrame = reader.ReadInt32();
            frameFlag = reader.ReadByte();
            loopOffset = reader.ReadSByte();
            loopInterval = reader.ReadByte();
            playDirection = reader.ReadByte();
            playSpeedSequenceVariable = reader.ReadByte();
            padding4 = reader.ReadByte();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(isDelete);
            writer.Write(index);
            writer.Write(soundId);
            writer.Write(soundName);
            writer.Write(volume);
            writer.Write(padding1);
            writer.Write(padding2);
            writer.Write(padding3);
            writer.Write(pitch);
            writer.Write(startFrame);
            writer.Write(endFrame);
            writer.Write(frameFlag);
            writer.Write(loopOffset);
            writer.Write(loopInterval);
            writer.Write(playDirection);
            writer.Write(playSpeedSequenceVariable);
            writer.Write(padding4);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
         EFBカラー変更メッセージ
        </summary> */
    public class ToolTestEfbColor
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 1 + 1 + 1 + 1;
        /** <summary>1B: R成分</summary> */
        public byte r;
        /** <summary>1B: G成分</summary> */
        public byte g;
        /** <summary>1B: B成分</summary> */
        public byte b;
        /** <summary>1B: A成分</summary> */
        public byte a;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            r = reader.ReadByte();
            g = reader.ReadByte();
            b = reader.ReadByte();
            a = reader.ReadByte();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(r);
            writer.Write(g);
            writer.Write(b);
            writer.Write(a);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>
            未定義コマンドエラーメッセージ

            受け取った未定義コマンドをcommandパラメータで返します。
        </summary> */
    public class ErrSystemUnknownCommand
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 2;
        /** <summary>  2B: 受け取った未定義コマンド  </summary> */
        public ushort command;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            command = reader.ReadUInt16();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(command);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>データの読み込みエラー種別</summary> */
    public enum Err3DLoadCode
    {
        /** <summary>ファイルのロードに失敗しました。        </summary> */
        ERR_3D_LOAD_FILE_NOT_FOUND = 0,
        /** <summary>メモリのアロケーションに失敗しました。  </summary> */
        ERR_3D_LOAD_MEMORY_ALLOCATE = 1,
        /** <summary>有効なデータではありませんでした。      </summary> */
        ERR_3D_LOAD_INVALID_DATA = 2,
        /** <summary>MCS通信で異常が発生しました。           </summary> */
        ERR_3D_LOAD_MCS_STREAM_FAIL = 3,
    }

    //-----------------------------------------------------------------------
    /** <summary>
            データの読み込みエラー
        </summary> */
    public class Err3DLoad
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>  4B: エラーコード          </summary> */
        public Err3DLoadCode code;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            code = (Err3DLoadCode)reader.ReadInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)code);
        }

    }

    //-----------------------------------------------------------------------
    /** <summary>サウンドエラー</summary> */
    public class SoundError
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary> 4B: エラーコード</summary> */
        public uint errorCode;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(BinaryReader reader)
        {
            errorCode = reader.ReadUInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(BinaryWriter writer)
        {
            writer.Write(errorCode);
        }
    }

#if false
    /** <summary>
        </summary> */
    public class SreSync
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 8;
        /** <summary>4B: タグ名</summary> */
        public uint version;
        public bool isSoundPlayer;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            version = reader.ReadUInt32();
            isSoundPlayer = ( (int)reader.ReadByte() != 0 ? true : false );
            reader.ReadByte();
            reader.ReadByte();
            reader.ReadByte();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
        }
    }
#endif

    /** <summary>
        </summary> */
    public class SreSyncReply
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4;
        /** <summary>4B: タグ名</summary> */
        public bool isAccept;
        private byte padding1 = 0;
        private byte padding2 = 0;
        private byte padding3 = 0;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            isAccept = ((int)reader.ReadByte() != 0 ? true : false);
            reader.ReadByte();
            reader.ReadByte();
            reader.ReadByte();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((byte)(isAccept != false ? 1 : 0));
            writer.Write(padding1);
            writer.Write(padding2);
            writer.Write(padding3);
        }
    }

#if false
    /** <summary>
        </summary> */
    public class QueryInvalidItemsReply
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public int StructSize
        {
            get
            {
                int size = 1 + 1 + 1 + 1 + 4;

                if( invalidItems != null )
                {
                    foreach( InvalidItem item in invalidItems )
                    {
                        size += 4;  // オフセットの分
                        size += 4;  // 名前長の分
                        size += 4;  // データタイプ(InvalidDataType)の分
                        size += ActualItemNameSize( item.Name);
                    }
                }

                return size;
            }
        }

        public bool isAllItems = false;
        public InvalidItem[] invalidItems = null;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            int itemCount = invalidItems != null ? invalidItems.Length : 0;

            writer.Write((byte)( isAllItems != false ? 1 : 0));
            writer.Write((byte)0);
            writer.Write((byte)0);
            writer.Write((byte)0);
            writer.Write(itemCount);

            if( itemCount > 0 )
            {
                int offset = invalidItems.Length * sizeof(int);
                foreach( InvalidItem item in invalidItems )
                {
                    writer.Write(offset);
                    offset += ( sizeof(uint)
                                + ActualItemNameSize( item.Name) // name + '0' + paddingのサイズ
                                + sizeof(int)                    // name.Langthのサイズ
                                - sizeof(int));                  // offset一個分のサイズ
                }

                foreach( InvalidItem item in invalidItems )
                {
                    int length = ActualItemNameSize( item.Name);
                    int nameLength = item.Name.Length + 1;
                    int paddingLength = length - nameLength;
                    byte[] nameArray = Encoding.GetEncoding(932).GetBytes( item.Name);

                    writer.Write(item.DataType);
                    writer.Write(nameLength);
                    writer.Write(nameArray);
                    writer.Write((byte)0);    //'\0'
                    for( int loop = 0; loop < paddingLength; loop++ )
                    {
                        writer.Write((byte)0);
                    }
                }
            }
        }

        ///
        private int ActualItemNameSize( string name)
        {
            int nameLength = name.Length + 1; //'\0\分 + 1
            return ( nameLength / 4 + (( nameLength % 4 ) != 0 ? 1 : 0 )) * 4;
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class InvalidItem
    {
        private uint dataType = 0;
        private string name = null;

        public InvalidItem( string name, uint dataType)
        {
            this.name = name;
            this.dataType = dataType;
        }

        public string Name
        {
            get
            {
                return this.name;
            }
        }

        public uint DataType
        {
            get
            {
                return this.dataType;
            }
        }

        public void MergeDataType( uint dataType)
        {
            this.dataType |= dataType;
        }
    }
#else

    /** <summary>
        </summary> */
    public class QueryItemsReply
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public int StructSize
        {
            get
            {
                int size = 4 + 4;

                if (this.items != null)
                {
                    foreach (ItemInfo item in this.items)
                    {
                        size += 4;  // オフセットの分
                        size += 4;  // ActionTypeの分
                        size += 4;  // 名前長の分
                        size += ActualItemNameSize(item.Name);
                    }
                }

                return size;
            }
        }

        public ItemInfo[] items = null;
        public int allItemsAction = 0;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            int itemCount = this.items != null ? items.Length : 0;

            writer.Write(allItemsAction);
            writer.Write(itemCount);

            if (itemCount > 0)
            {
                int offset = itemCount * sizeof(int);
                foreach (ItemInfo item in this.items)
                {
                    writer.Write(offset);
                    offset += (sizeof(int)                      // ActionTypeのサイズ
                                + ActualItemNameSize(item.Name) // name + '0' + paddingのサイズ
                                + sizeof(int)                    // name.Langthのサイズ
                                - sizeof(int));                  // offset一個分のサイズ
                }

                foreach (ItemInfo item in this.items)
                {
                    int length = ActualItemNameSize(item.Name);
                    int nameLength = item.Name.Length + 1;
                    int paddingLength = length - nameLength;
                    byte[] nameArray = Encoding.GetEncoding(932).GetBytes(item.Name);

                    writer.Write((int)item.ActionType);
                    writer.Write(nameLength);
                    writer.Write(nameArray);
                    writer.Write((byte)0);    //'\0'
                    for (int loop = 0; loop < paddingLength; loop++)
                    {
                        writer.Write((byte)0);
                    }
                }
            }
        }

        ///
        private int ActualItemNameSize(string name)
        {
            int nameLength = name.Length + 1; //'\0\分 + 1
            return (nameLength / 4 + ((nameLength % 4) != 0 ? 1 : 0)) * 4;
        }
    }

    ///
    public class ItemInfo
    {
        public ActionType ActionType { get; set; }
        public string Name { get; set; }

        public ItemInfo(ActionType actionType, string name)
        {
            ActionType = actionType;
            Name = name;
        }
    }

    ///
    public enum ActionType
    {
        UPDATE_ITEM = 1,
        DELETE_ITEM = 2,
    }
#endif
#if true

    /** <summary>
        </summary> */
    public class SreSync
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 16;
        /** <summary>4B: タグ名</summary> */
        public uint version;
        public uint memoryMax;
        public uint memoryUsage;

        public uint editableItemCountMax;
        public uint editableItemCount;
        public uint editableFileCountMax;
        public uint editableFileCount;
        public bool isOutOfMemory;
        public bool isItemOverflow;
        public bool isFileOverflow;
        public bool isSoundPlayer;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            version = reader.ReadUInt32();
            memoryMax = reader.ReadUInt32();
            memoryUsage = reader.ReadUInt32();

            editableItemCountMax = reader.ReadUInt32();
            editableItemCount = reader.ReadUInt32();
            editableFileCountMax = reader.ReadUInt32();
            editableFileCount = reader.ReadUInt32();

            isOutOfMemory = ((int)reader.ReadByte() != 0 ? true : false);
            isItemOverflow = ((int)reader.ReadByte() != 0 ? true : false);
            isFileOverflow = ((int)reader.ReadByte() != 0 ? true : false);

            reader.ReadByte();
            isSoundPlayer = ((int)reader.ReadByte() != 0 ? true : false);
            reader.ReadByte();
            reader.ReadByte();
            reader.ReadByte();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
        }
    }

    //---------------------------------------------------------------------------
    //! @brief
    //---------------------------------------------------------------------------
    public enum SoundType
    {
        SOUND_TYPE_INVALID = 0,     //!< 不正な種類のサウンドです。

        SOUND_TYPE_STRM = 1,        //!< ストリームサウンドです。
        SOUND_TYPE_WAVE = 2,        //!< ウェーブサウンドです。
        SOUND_TYPE_SEQ = 3,        //!< シーケンスサウンドです。
        SOUND_TYPE_BANK = 4,        //!< バンクです。
    }

    //---------------------------------------------------------------------------
    //! @brief  サウンドの基本の編集情報です。
    //---------------------------------------------------------------------------
    public class SoundBasicParam
    {
        public byte volume;                        //!< 音量
        public byte panMode;                       //!< パンモード
        public byte panCurve;                      //!< パンカーブ
        public byte playerPriority;                //!< プレイヤー優先度
        public int playerNameOffset;
        public byte actorPlayerID;                 //!< アクタープレイヤーID
        public byte remoteFilter;                  //!< リモコンフィルタ
        public byte flags;                         //!< 0bit目: FrontBypass
        public byte singlePlayType;                //!< 単一再生の種類
        public ushort singlePlayEffectiveDuration; //!< 単一再生の有効時間
        public byte[] padding = new byte[2];       //!< パディング
        public uint[] userParam = new uint[4];     //!< ユーザーデータ

        //public byte[] nameArray;               //!< アイテム名
        //public uint namePadding;

        public virtual int Size
        {
            get
            {
                return (1 +  // volume
                         1 +  // panMode
                         1 +  // panCurve
                         1 +  // playerPriority
                         4 +  // playerNameOffset
                         1 +  // actorPlayerID
                         1 +  // remoteFilter
                         1 +  // flags
                         1 +  // singlePlayType
                         2 +  // singlePlayEffectiveDuration
                         2 +  // padding
                         (4 * 4)); // userParam
            }
        }

        public static int SizeOfPlayerNameOffsetTo = (4 +  // playerNameOffset
                                                      1 +  // actorPlayerID
                                                      1 +  // remoteFilter
                                                      1 +  // flags
                                                      1 +  // singlePlayType
                                                      2 +  // singlePlayEffectiveDuration
                                                      2 +  // padding
                                                      (4 * 4)); // userParam

        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(volume);
            writer.Write(panMode);
            writer.Write(panCurve);
            writer.Write(playerPriority);

            writer.Write(playerNameOffset);

            writer.Write(actorPlayerID);
            writer.Write(remoteFilter);
            writer.Write(flags);
            writer.Write(singlePlayType);
            writer.Write(singlePlayEffectiveDuration);
            writer.Write(padding);
            for (int index = 0; index < userParam.Length; index++)
            {
                writer.Write(userParam[index]);
            }
        }
    }

    //---------------------------------------------------------------------------
    //! @brief  3Dサウンドの編集情報です。
    //---------------------------------------------------------------------------
    public class Sound3DParam
    {
        public uint flags;                      //!< [0]Vol [1]Priotity [2]Pan [3]SPan [4]Filter
        public float decayRatio;                //!< 減衰率
        public byte decayCurve;                //!< 減衰カーブタイプ (nw::snd::DecayCurve が入る)
        public byte dopplerFactor;             //!< ドップラーファクター
        public byte[] padding = new byte[2];    //!< パディング

        public virtual int Size
        {
            get
            {
                return (4 +
                         4 +
                         1 +
                         1 +
                         2);
            }
        }

        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(flags);
            writer.Write(decayRatio);
            writer.Write(decayCurve);
            writer.Write(dopplerFactor);
            writer.Write(padding);
        }
    }

    //---------------------------------------------------------------------------
    //! @brief
    //---------------------------------------------------------------------------
    public class SendsParam
    {
        public byte mainSend;
        public byte[] fxSends = new byte[3];

        public static int Size
        {
            get
            {
                return (4);
            }
        }

        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(mainSend);
            writer.Write(fxSends);
        }
    }

    //---------------------------------------------------------------------------
    //! @brief
    //---------------------------------------------------------------------------
    public class StreamSoundTrackParam
    {
        public const int MaxChannelCount = 2;

        public byte volume;
        public byte pan;
        public byte span;
        public byte channelCount;
        public byte[] channelIndexes = new byte[MaxChannelCount];
        public byte[] padding = new byte[2];  // パディング
        public byte lpf;
        public byte biquadType;
        public byte biquadValue;
        public byte flags;   // 0bit目: FrontBypass
        public SendsParam sends = new SendsParam();

        public StreamSoundTrackParam()
        {
            for (int index = 0; index < MaxChannelCount; ++index)
            {
                channelIndexes[index] = 0;
            }
        }

        public static int Size
        {
            get
            {
                return (1 + // volume
                        1 + // pan
                        1 + // span
                        1 + // channelCount
                        1 * MaxChannelCount + // channelIndexes
                        2 + // パディング
                        1 + // lpf
                        1 + // biquadType
                        1 + // biquadValue
                        1 + // flags
                        SendsParam.Size // Sends分
                        );
            }
        }

        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(volume);
            writer.Write(pan);
            writer.Write(span);
            writer.Write(channelCount);

            foreach (byte channelIndex in channelIndexes)
            {
                writer.Write(channelIndex);
            }
            writer.Write(padding);

            writer.Write(lpf);
            writer.Write(biquadType);
            writer.Write(biquadValue);
            writer.Write(flags);
            this.sends.Write(writer);
        }
    }

    //---------------------------------------------------------------------------
    //! @brief
    //---------------------------------------------------------------------------
    public class StreamSoundParam
    {
        public StreamSoundTrackParam[] trackParams = null;
        public ushort trackAllocationFlags;
        public ushort totalChannelCount;
        public int fileSize;
        public int filePathOffset;
        public string filePath;
        public float pitch;
        public SendsParam sends = new SendsParam();
        public byte streamFileType;

        public int prefetchFileSize;
        public int prefetchFilePathOffset;
        public string prefetchFilePath;
        public byte[] bfstmFileHashCode = new byte[32];

        static StreamSoundParam()
        {
            MaxTrackCount = 8;
        }

        public static int MaxTrackCount
        {
            get;
            set;
        }

        public StreamSoundParam()
        {
            trackParams = new StreamSoundTrackParam[MaxTrackCount];
            for (int index = 0; index < MaxTrackCount; ++index)
            {
                trackParams[index] = new StreamSoundTrackParam();
            }
        }

        public virtual int Size
        {
            get
            {
                return ((StreamSoundTrackParam.Size * MaxTrackCount) +
                        sizeof(ushort) +  // trackAllocationFlags分
                        sizeof(ushort) +  // totalChannelCount分
                        sizeof(int) +     // fileSize分
                        sizeof(int) +     // filePathOffset分
                        sizeof(float) +   // pitch分
                        SendsParam.Size + // Sends分
                        sizeof(byte) +    // streamFileType分
                        3 +                // padding

                        sizeof(int) +     // prefetchFileSize分
                        sizeof(int) +     // prefetchFilePathOffset分
                        32                // bfstmFileHashCode分
                        );
            }
        }

        /// SizeOfFilePathOffsetTo = pitch分 + Sends分 + streamFileType分 + padding +
        /// prefetchFileSize分 + prefetchFilePathOffset分 + bfstmFileHashCode分
        public static int SizeOfFilePathOffsetTo = (4 + 4 + SendsParam.Size + 4 + 4 + 4 + 32);

        ///
        public static int SizeOfPrefetchFilePathOffsetTo = (4 + 32);


        public virtual void Write(ProtocolSoundWriter writer)
        {
            foreach (var trackParam in trackParams)
            {
                trackParam.Write(writer);
            }

            writer.Write(trackAllocationFlags);
            writer.Write(totalChannelCount);
            writer.Write(fileSize);
            writer.Write(filePathOffset);
            writer.Write(pitch);
            this.sends.Write(writer);
            writer.Write(streamFileType);
            writer.Write(new byte[3]);
            writer.Write(this.prefetchFileSize);
            writer.Write(this.prefetchFilePathOffset);
            writer.Write(this.bfstmFileHashCode);
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class StreamSoundParam2
    {
        private byte[] padding = new byte[3];
        public bool isLoop;
        public uint loopStartFrame;
        public uint loopEndFrame;

        public virtual int Size
        {
            get
            {
                return 1 + 3 + 4 + 4;
            }
        }

        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((byte)(isLoop != false ? 1 : 0));
            writer.Write(padding);
            writer.Write(loopStartFrame);
            writer.Write(loopEndFrame);
        }
    }

    //---------------------------------------------------------------------------
    //! @brief
    //---------------------------------------------------------------------------
    public class WaveSoundNoteParam
    {
        public int waveArchiveNameOffset;
        public uint waveArchiveId;
        public uint waveIndex;
        public uint adshr;
        public byte originalKey;
        public byte pan;
        public byte surroundPan;
        public byte volume;
        public float pitch;

        public virtual int Size
        {
            get
            {
                return (4 +  //offset分
                         4 +
                         4 +
                         4 +
                         1 +
                         1 +
                         1 +
                         1 +
                         4);
            }
        }

        public static int SizeOfWaveArchiveNameOffsetTo = (4 +
                                                            4 +
                                                            4 +
                                                            4 +
                                                            1 +
                                                            1 +
                                                            1 +
                                                            1 +
                                                            4);

        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(waveArchiveNameOffset);
            writer.Write(waveArchiveId);
            writer.Write(waveIndex);
            writer.Write(adshr);
            writer.Write(originalKey);
            writer.Write(pan);
            writer.Write(surroundPan);
            writer.Write(volume);
            writer.Write(pitch);
        }
    }

    //---------------------------------------------------------------------------
    //! @brief
    //---------------------------------------------------------------------------
    public class WaveSoundParam
    {
        public byte channelPriority;          //!< チャンネル優先度
        public bool isReleasePriorityFix;     //!< リリース時優先度固定
        public byte[] padding = new byte[2];  //!< パディング
        public uint waveIndex;
        public string bfwsdFilePath;
        public string bfwarFilePath;
        public int bfwsdFileSize;
        public int bfwarFileSize;
        public int bfwsdFilePathOffset;
        public int bfwarFilePathOffset;
        public byte[] bfwsdFileHashCode = new byte[32];
        public byte[] bfwarFileHashCode = new byte[32];

        public virtual int Size
        {
            get
            {
                return (1 +   // チャンネル優先度
                         1 +   // リリース時優先度固定
                         2 +   // padding
                         4 +   // 波形インデックス
                         4 +   // bfwsdファイルサイズ
                         4 +   // bfwsdファイルパスへのオフセット
                        32 +   // bfwsdファイルハッシュ値
                         4 +   // bfwarファイルサイズ
                         4 +   // bfwarファイルパスへのオフセット
                        32);   // bfwarファイルハッシュ値
            }
        }

        public const int SizeOfBfwsdFilePathOffsetTo = (4 +
                                                        32 +
                                                         4 +
                                                         4 +
                                                        32);
        public const int SizeOfBfwarFilePathOffsetTo = (4 +
                                                        32);

        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(channelPriority);
            writer.Write((byte)(isReleasePriorityFix != false ? 1 : 0));
            writer.Write(padding);
            writer.Write(waveIndex);
            writer.Write(bfwsdFileSize);
            writer.Write(bfwsdFilePathOffset);
            writer.Write(bfwsdFileHashCode);
            writer.Write(bfwarFileSize);
            writer.Write(bfwarFilePathOffset);
            writer.Write(bfwarFileHashCode);
        }
    }

    //---------------------------------------------------------------------------
    //! @brief
    //---------------------------------------------------------------------------
    public class SequenceSoundParam
    {
        private const uint InvalidID = uint.MaxValue;

        public uint startOffset;                 //!< 再生開始位置
        public byte channelPriority;             //!< チャンネル優先度
        public bool isReleasePriorityFix;        //!< リリース時優先度固定
        public byte[] padding = new byte[2];     //!< パディング
        public uint trackAllocationFlags;        //!<

        public const int MaxBankCount = 4;
        public const int MaxWaveArchiveCount = 4;

        public int bfseqFileSize;
        public int bfseqFilePathOffset;
        public byte[] bfseqFileHashCode = new byte[32];
        public int[] bankNameOffsets = new int[MaxBankCount];

        public string bfseqFilePath = null;
        public string[] bankNames = null;

        public virtual int Size
        {
            get
            {
                return (sizeof(uint) +        // StartOffset
                         sizeof(byte) +        // ChannelPriority
                         sizeof(byte) +        // IsReleasePriorityFix
                         2 +                   // Padding
                         sizeof(uint) +        // TrackAllocationFlags
                         sizeof(int) +         // bfseqファイルのサイズ
                         sizeof(int) +         // bfseqオフセット
                         32 +                  // bfseqハッシュ値
                         (sizeof(int) * 4));   // bank nameオフセット * MaxBankCount
            }
        }

        public static int SizeOfBfseqFilePathOffsetTo = (4 +
                                                         32 +
                                                          (sizeof(int) * 4));

        public static int SizeOfBankNameBaseOffsetTo = (4 +
                                                         (sizeof(int) * 4));

        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(startOffset);
            writer.Write(channelPriority);
            writer.Write((byte)(isReleasePriorityFix != false ? 1 : 0));
            writer.Write(padding);
            writer.Write(trackAllocationFlags);

            writer.Write(bfseqFileSize);
            writer.Write(bfseqFilePathOffset);
            writer.Write(bfseqFileHashCode);

            for (int index = 0; index < bankNameOffsets.Length; index++)
            {
                writer.Write(bankNameOffsets[index]);
            }
        }
    }

    //---------------------------------------------------------------------------
    //! @brief
    //---------------------------------------------------------------------------
    public class BankParam
    {
        public int bfbnkFilePathOffset = 0;
        public int bfwarFilePathOffset = 0;

        public int bfbnkFileSize;
        public int bfwarFileSize;
        public string bfbnkFilePath = null;
        public string bfwarFilePath = null;
        public byte[] bfbnkFileHashCode = new byte[32];
        public byte[] bfwarFileHashCode = new byte[32];

        public virtual int Size
        {
            get
            {
                return (4 +    // bfbnkファイルのサイズ
                         4 +    // bfbnkオフセット
                        32 +    // bfbnkハッシュ値
                         4 +    // bfwarファイルのサイズ
                         4 +    // bfwarオフセット
                        32);    // bfwarハッシュ値
            }
        }

        public static int SizeOfBfbnkFilePathOffsetTo = (4 +
                                                         32 +
                                                          4 +
                                                          4 +
                                                         32);
        public static int SizeOfBfwarFilePathOffsetTo = (4 +
                                                         32);

        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(bfbnkFileSize);
            writer.Write(bfbnkFilePathOffset);
            writer.Write(bfbnkFileHashCode);
            writer.Write(bfwarFileSize);
            writer.Write(bfwarFilePathOffset);
            writer.Write(bfwarFileHashCode);
        }
    }

    //---------------------------------------------------------------------------
    //! @brief  サウンドの編集情報です。
    //---------------------------------------------------------------------------
    public class SoundEditInfo
    {
        public SoundType soundType;

        public SoundBasicParam soundBasicParam = new SoundBasicParam();  //!< 基本
        public Sound3DParam sound3DParam = new Sound3DParam();           //!< 3Dサウンド

        public string playerName;

        public virtual int Size
        {
            get
            {
                return 4 + soundBasicParam.Size + sound3DParam.Size;
            }
        }

        protected int SizeOfPlayerNameOffsetTo
        {
            get
            {
                return (SoundBasicParam.SizeOfPlayerNameOffsetTo +
                         sound3DParam.Size);
            }
        }

        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((uint)soundType);

            soundBasicParam.Write(writer);
            sound3DParam.Write(writer);
        }

        /// <summary>
        ///
        /// </summary>
        protected class ItemNamePack
        {
            public byte[] ByteArray { get; set; }
            public int PaddingLength { get; set; }
            public int Length { get; set; }

            /// <summary>
            ///
            /// </summary>
            public static ItemNamePack Create(string text)
            {
                int actualLength = ActualLength(text);
                int length = text.Length + 1;
                int paddingLength = actualLength - length;

                ItemNamePack pack = new ItemNamePack();
                pack.ByteArray = Encoding.GetEncoding(932).GetBytes(text);
                pack.PaddingLength = (paddingLength + 1); // +1は'\0'の分
                pack.Length = actualLength;

                return pack;
            }

            /// <summary>
            ///
            /// </summary>
            public static int GetPackSize(string filePath)
            {
                int actualLength = ActualLength(filePath);
                return (actualLength +  // パス文字列分
                         4);            // Length分(int)
            }

            /// <summary>
            ///
            /// </summary>
            public static int ActualLength(string filePath)
            {
                int length = filePath.Length + 1; //'\0\分 + 1
                return (length / 4 + ((length % 4) != 0 ? 1 : 0)) * 4;
            }

            /// <summary>
            ///
            /// </summary>
            public virtual int PackSize
            {
                get
                {
                    return (Length +    // パス文字列分
                             4);        // Length分(int)
                }
            }

            /// <summary>
            ///
            /// </summary>
            public virtual void Write(ProtocolSoundWriter writer)
            {
                writer.Write(ByteArray.Length);
                writer.Write(ByteArray);

                for (int loop = 0; loop < PaddingLength; loop++)
                {
                    writer.Write((byte)0);
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        protected class FilePathPack : ItemNamePack
        {
            public int FileSize { get; set; }

            /// <summary>
            ///
            /// </summary>
            public new static FilePathPack Create(string filePath)
            {
                int actualLength = ActualLength(filePath);
                int length = filePath.Length + 1;
                int paddingLength = actualLength - length;

                FilePathPack pack = new FilePathPack();
                pack.ByteArray = Encoding.GetEncoding(932).GetBytes(filePath);
                pack.PaddingLength = (paddingLength + 1); // +1は'\0'の分
                pack.Length = actualLength;

                try
                {
                    FileInfo fileInfo = new FileInfo(filePath);
                    pack.FileSize = (int)fileInfo.Length;
                }
                catch
                {
                    pack.FileSize = 0;
                }

                return pack;
            }

            /// <summary>
            ///
            /// </summary>
            public new static int GetPackSize(string filePath)
            {
                int actualLength = ActualLength(filePath);
                return (actualLength +  // パス文字列分
                         4 +             // Length分(int)
                         0 /*4*/ );            // ファイルサイズ分(int)
            }

            /// <summary>
            ///
            /// </summary>
            public override int PackSize
            {
                get
                {
                    return (base.PackSize +
                             0 /*4*/ );        // ファイルサイズ分(int)
                }
            }

            /// <summary>
            ///
            /// </summary>
            public override void Write(ProtocolSoundWriter writer)
            {
                //writer.Write( FileSize);
                base.Write(writer);
            }
        }
    }

    //---------------------------------------------------------------------------
    //! @brief  ストリームサウンドの編集情報です。
    //---------------------------------------------------------------------------
    public class StreamSoundEditInfo : SoundEditInfo
    {
        public StreamSoundParam streamSoundParam = new StreamSoundParam();
        public StreamSoundParam2 streamSoundParam2 = new StreamSoundParam2();

        public StreamSoundEditInfo()
        {
            soundType = SoundType.SOUND_TYPE_STRM;
        }

        public override int Size
        {
            get
            {
                return (base.Size +
                         streamSoundParam.Size +
                         streamSoundParam2.Size +
                         ItemNamePack.GetPackSize(playerName) +
                         FilePathPack.GetPackSize(streamSoundParam.filePath) +
                         FilePathPack.GetPackSize(streamSoundParam.prefetchFilePath));
            }
        }

        public override void Write(ProtocolSoundWriter writer)
        {
            soundBasicParam.playerNameOffset = (SizeOfPlayerNameOffsetTo +
                                                 streamSoundParam.Size +
                                                 streamSoundParam2.Size);
            base.Write(writer);

            //
            ItemNamePack playerPack = ItemNamePack.Create(playerName);
            FilePathPack filePathPack = FilePathPack.Create(streamSoundParam.filePath);
            FilePathPack prefetchFilePathPack = FilePathPack.Create(streamSoundParam.prefetchFilePath);

            streamSoundParam.fileSize = filePathPack.FileSize;
            streamSoundParam.filePathOffset =
                (StreamSoundParam.SizeOfFilePathOffsetTo +
                  streamSoundParam2.Size +
                  4 + playerPack.Length); // 4は nameLength分

            streamSoundParam.prefetchFileSize = prefetchFilePathPack.FileSize;
            streamSoundParam.prefetchFilePathOffset =
                (StreamSoundParam.SizeOfPrefetchFilePathOffsetTo +
                  streamSoundParam2.Size +
                  4 + playerPack.Length +
                  4 + filePathPack.Length);

            streamSoundParam.Write(writer);
            streamSoundParam2.Write(writer);

            // プレイヤー名
            playerPack.Write(writer);

            // バイナリファイルパス
            filePathPack.Write(writer);

            // プリフェッチバイナリファイルパス
            prefetchFilePathPack.Write(writer);
        }
    }

    //---------------------------------------------------------------------------
    //! @brief  ウェーブサウンドの編集情報です。
    //---------------------------------------------------------------------------
    public class WaveSoundEditInfo : SoundEditInfo
    {
        public WaveSoundParam waveSoundParam = new WaveSoundParam();

        public WaveSoundEditInfo()
        {
            soundType = SoundType.SOUND_TYPE_WAVE;
        }

        public override int Size
        {
            get
            {
                return (base.Size +
                         waveSoundParam.Size +
                         ItemNamePack.GetPackSize(playerName) +
                         FilePathPack.GetPackSize(waveSoundParam.bfwsdFilePath) +
                         FilePathPack.GetPackSize(waveSoundParam.bfwarFilePath));
            }
        }

        public override void Write(ProtocolSoundWriter writer)
        {
            soundBasicParam.playerNameOffset = (SizeOfPlayerNameOffsetTo +
                                                 waveSoundParam.Size);
            base.Write(writer);

            //
            ItemNamePack playerPack = ItemNamePack.Create(playerName);
            FilePathPack bfwsdPack = FilePathPack.Create(waveSoundParam.bfwsdFilePath);
            FilePathPack bfwarPack = FilePathPack.Create(waveSoundParam.bfwarFilePath);

            int baseOffset = ((4 + playerPack.Length));

            // バイナリウェーブサウンドファイルのサイズ、パスまでのオフセット
            waveSoundParam.bfwsdFileSize = bfwsdPack.FileSize;
            waveSoundParam.bfwsdFilePathOffset =
                (WaveSoundParam.SizeOfBfwsdFilePathOffsetTo +
                  baseOffset);

            // バイナリ波形アーカイブファイルのサイズ、パスまでのオフセット
            waveSoundParam.bfwarFileSize = bfwarPack.FileSize;
            waveSoundParam.bfwarFilePathOffset =
                (WaveSoundParam.SizeOfBfwarFilePathOffsetTo +
                  baseOffset +
                  (4 + bfwsdPack.Length));

            waveSoundParam.Write(writer);

            //
            playerPack.Write(writer);
            bfwsdPack.Write(writer);
            bfwarPack.Write(writer);
        }
    }

    //---------------------------------------------------------------------------
    //! @brief  シーケンスサウンドの編集情報です。
    //---------------------------------------------------------------------------
    public class SequenceSoundEditInfo : SoundEditInfo
    {
        public SequenceSoundParam sequenceSoundParam = new SequenceSoundParam();

        //public List<string> bankNames = new List<string>();

        public SequenceSoundEditInfo()
        {
            soundType = SoundType.SOUND_TYPE_SEQ;
        }

        public override int Size
        {
            get
            {
                int bfbnkSize = 0;
                foreach (string filePath in sequenceSoundParam.bankNames)
                {
                    bfbnkSize += 4 + FilePathPack.ActualLength(filePath);
                }

                return (base.Size +
                         sequenceSoundParam.Size +
                         ItemNamePack.GetPackSize(playerName) +
                         FilePathPack.GetPackSize(sequenceSoundParam.bfseqFilePath) +
                         bfbnkSize);
            }
        }

        public override void Write(ProtocolSoundWriter writer)
        {
            soundBasicParam.playerNameOffset = (SizeOfPlayerNameOffsetTo +
                                                 sequenceSoundParam.Size);
            base.Write(writer);

            //
            ItemNamePack playerPack = ItemNamePack.Create(playerName);
            FilePathPack bfseqPack = FilePathPack.Create(sequenceSoundParam.bfseqFilePath);

            //
            int bankNameCount = SequenceSoundParam.MaxBankCount;
            ItemNamePack[] bankNamePacks = new ItemNamePack[bankNameCount];
            for (int index = 0; index < bankNameCount; index++)
            {
                if (index < sequenceSoundParam.bankNames.Length)
                {
                    bankNamePacks[index] =
                        ItemNamePack.Create(sequenceSoundParam.bankNames[index]);
                }
            }

            // オフセットの計算
            int offset = (SequenceSoundParam.SizeOfBfseqFilePathOffsetTo +
                           playerPack.PackSize);

            // バイナリシーケンスファイルパスまでのオフセット
            sequenceSoundParam.bfseqFileSize = bfseqPack.FileSize;
            sequenceSoundParam.bfseqFilePathOffset = offset;
            offset += bfseqPack.PackSize - 4;

            // バンク名までのオフセット
            int bankNameOffset = (SequenceSoundParam.SizeOfBankNameBaseOffsetTo +
                                   playerPack.PackSize +
                                   bfseqPack.PackSize -
                                   4);

            for (int index = 0; index < bankNameCount; index++)
            {
                if (bankNamePacks[index] != null)
                {
                    sequenceSoundParam.bankNameOffsets[index] = bankNameOffset;
                    bankNameOffset += bankNamePacks[index].PackSize;
                }
                else
                {
                    sequenceSoundParam.bankNameOffsets[index] = 0;
                }
                bankNameOffset -= 4;
            }

            //
            sequenceSoundParam.Write(writer);

            // プレイヤー名、ファイルパスの書き込み
            playerPack.Write(writer);
            bfseqPack.Write(writer);

            //
            for (int index = 0; index < bankNameCount; index++)
            {
                if (bankNamePacks[index] != null)
                {
                    bankNamePacks[index].Write(writer);
                }
            }
        }
    }

    //---------------------------------------------------------------------------
    //! @brief  バンクの編集情報です。
    //---------------------------------------------------------------------------
    public class BankEditInfo : SoundEditInfo
    {
        public BankParam bankParam = new BankParam();

        public BankEditInfo()
        {
            soundType = SoundType.SOUND_TYPE_BANK;
        }

        public override int Size
        {
            get
            {
                return (4 + // SoundType
                         bankParam.Size +
                         FilePathPack.GetPackSize(bankParam.bfbnkFilePath) +
                         FilePathPack.GetPackSize(bankParam.bfwarFilePath));
            }
        }

        public override void Write(ProtocolSoundWriter writer)
        {
            FilePathPack bfbnkPack = FilePathPack.Create(bankParam.bfbnkFilePath);
            FilePathPack bfwarPack = FilePathPack.Create(bankParam.bfwarFilePath);

            // オフセットの計算
            // バイナリバンクファイルパスまでのオフセット
            bankParam.bfbnkFileSize = bfbnkPack.FileSize;
            int offset = BankParam.SizeOfBfbnkFilePathOffsetTo;
            bankParam.bfbnkFilePathOffset = offset;

            // バイナリ波形アーカイブファイルパスまでのオフセット
            bankParam.bfwarFileSize = bfwarPack.FileSize;
            offset = BankParam.SizeOfBfwarFilePathOffsetTo;
            offset += (4 + bfbnkPack.Length);
            bankParam.bfwarFilePathOffset = offset;

            //
            writer.Write((int)soundType);
            this.bankParam.Write(writer);

            bfbnkPack.Write(writer);
            bfwarPack.Write(writer);
        }
    }
#endif
}
