﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Framework.FileManagement
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using FileFormats;
    using SoundFoundation.Core.IO;

    public class FileParserStore
    {
        private Dictionary<Key, IFileParser> loadedFiles = new Dictionary<Key, IFileParser>();

        public FileParserStore(bool isLittleEndian)
        {
            this.IsLittleEndian = isLittleEndian;
        }

        public bool IsLittleEndian { get; private set; }

        public TFileParser Parse<TFileParser>(string filePath)
            where TFileParser : class, IFileParser, new()
        {
            Key key = new Key()
            {
                Type = typeof(TFileParser),
                FilePath = filePath,
            };

            IFileParser fileParser = null;
            this.loadedFiles.TryGetValue(key, out fileParser);

            if (fileParser != null)
            {
                if (!fileParser.IsUpdated)
                {
                    return fileParser as TFileParser;
                }
            }
            else
            {
                fileParser = new TFileParser()
                {
                    IsLittleEndian = this.IsLittleEndian,
                };
            }

            fileParser.Parse(filePath);

            if (this.loadedFiles.ContainsKey(key))
            {
                this.loadedFiles[key] = fileParser;
            }
            else
            {
                this.loadedFiles.Add(key, fileParser);
            }

            return fileParser as TFileParser;
        }

        private struct Key
        {
            public Type Type { get; set; }
            public string FilePath { get; set; }
        }
    }
}
