﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using NintendoWare.SoundMaker.Framework.Configurations;

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    public partial class XmlBankDocumentView
    {
        public static readonly string[] ListNames = new string[] {
                                                        ListTraits.ListName_Instrument,
                                                        ListTraits.ListName_Percussion,
                                                    };

        public static XmlBankDocumentView CreateInstance(string filePath)
        {
            return new XmlBankDocumentView()
            {
                FilePath = filePath,
                InstrumentListView = new Schemas.XmlBankDocumentViewInstrumentListView(),
            };
        }

        public override bool Validate()
        {
            return Validate(Lists.ExportDictionary());
        }

        public bool Validate(IDictionary<string, XmlList> xmlLists)
        {
            if (null == xmlLists) { throw new ArgumentNullException("xmlLists"); }

            if (null == Lists) { return false; }
            if (null == Lists.List) { return false; }

            foreach (string listName in ListNames)
            {
                if (!xmlLists.ContainsKey(listName)) { return false; }
            }

            return true;
        }
    }
}
