﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;

namespace NintendoWare.SoundMaker.Framework.Configurations
{
    /// <summary>
    /// リストの特性を表します。
    /// </summary>
    public class ListTrait
    {
        private string _name;
        private IEnumerable<string> _columns;

        public ListTrait(string name, IEnumerable<string> columns)
        {
            if (null == name) { throw new ArgumentNullException("name"); }
            if (null == columns) { throw new ArgumentNullException("columns"); }

            _name = name;
            _columns = columns;
        }

        public string Name
        {
            get { return _name; }
        }

        public IEnumerable<string> Columns
        {
            get { return _columns; }
        }
    }
}
