﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Commands
{
    using System.Collections.Generic;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Core.Reflection;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.SoundMaker.Framework.Windows;

    /// <summary>
    /// 表示関連コマンドを管理します。
    /// </summary>
    public static class ViewCommands
    {
        /// <summary>
        /// 表示関連コマンドを列挙する IEnumerable を取得します。
        /// </summary>
        public static IEnumerable<Command> Commands
        {
            get
            {
                return ObjectFinder.FindStaticValues<Command>(typeof(ViewCommands),
                                                               BindingFlags.GetProperty | BindingFlags.GetField);
            }
        }

        /// <summary>
        /// プロジェクトツリーをタブに同期。
        /// </summary>
        public static readonly Command SynchronizeTree =
            new Command("View.SynchronizeTree", MessageResource.Command_View_SynchronizeTree_Name)
            {
#if false
                Text = MessageResource.Command_View_SynchronizeTree_Text,
#endif
            };

        /// <summary>
        /// 波形ファイルの情報を更新します。
        /// </summary>
        public static readonly Command UpdateWaveFileInformation =
            new Command("View.UpdateWaveFileInformation", MessageResource.Command_View_UpdateWaveFileInformation_Name)
            {
            };

        /// <summary>
        /// プロジェクトツリーを表示。
        /// </summary>
        public static readonly Command ShowProjectTreeWindow =
            new Command("View.ShowProjectTreeWindow", MessageResource.Command_View_ShowProjectTreeWindow_Name)
            {
#if false
                Text = MessageResource.Command_View_ShowProjectTreeWindow_Text,
#endif
                Image = ImageResource.BitmapIconProjectTreeWindow.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// パラメータパネルを表示。
        /// </summary>
        public static readonly Command ShowParameterWindow =
            new Command("View.ShowParameterWindow", MessageResource.Command_View_ShowParameterWindow_Name)
            {
#if false
                Text = MessageResource.Command_View_ShowParameterWindow_Text,
#endif
                Image = ImageResource.BitmapIconParameterWindow.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// コンバートログを表示。
        /// </summary>
        public static readonly Command ShowConvertLogWindow =
            new Command("View.ShowConvertLogWindow", MessageResource.Command_View_ShowConvertLogWindow_Name)
            {
#if false
                Text = MessageResource.Command_View_ShowConvertLogWindow_Text,
#endif
                Image = ImageResource.BitmapIconOutputWindow.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// 波形参照の計測パネルを表示。
        /// </summary>
        public static readonly Command ShowMeasureWaveReferenceCountWindow =
            new Command("View.ShowMeasureWaveReferenceCountWindow", MessageResource.Command_View_ShowMeasureWaveReferenceCountWindow_Name)
            {
                Image = ImageResource.BitmapIconMeasureWaveReferenceCountWindow.MakeNewTransparent
                        (UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// ウェーブサウンド編集を表示。
        /// </summary>
        public static readonly Command ShowWaveSoundEditorWindow =
            new Command("View.ShowWaveSoundEditorWindow", MessageResource.Command_View_ShowWaveSoundEditorWindow_Name)
            {
                Image = ImageResource.BitmapIconWaveSoundEditWindow.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// プレビュープレイヤーを表示。
        /// </summary>
        public static readonly Command ShowPreviewPlayerWindow =
            new Command("View.ShowPreviewPlayerWindow", MessageResource.Command_View_ShowPreviewPlayerWindow_Name)
            {
#if false
                Text = MessageResource.Command_View_ShowPreviewPlayerWindow_Text,
#endif
                Image = ImageResource.BitmapIconPreviewPlayerWindow.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// プレビューバンクを表示。
        /// </summary>
        public static readonly Command ShowPreviewBankWindow =
            new Command("View.ShowPreviewBankWindow", MessageResource.Command_View_ShowPreviewBankWindow_Name)
            {
#if false
                Text = MessageResource.Command_View_ShowPreviewBankWindow_Text,
#endif
                Image = ImageResource.BitmapIconPreviewBankWindow.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// プレビュープレイヤーパラメータを表示。
        /// </summary>
        public static readonly Command ShowPreviewPlayerParameterWindow =
            new Command("View.ShowPreviewPlayerParameterWindow", MessageResource.Command_View_ShowPreviewPlayerParameterWindow_Name)
            {
#if false
                Text = MessageResource.Command_View_ShowPreviewPlayerParameterWindow_Text,
#endif
                Image = ImageResource.BitmapIconPreviewPlayerParamWindow.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// シーケンス変数を表示。
        /// </summary>
        public static readonly Command ShowSequenceVariableWindow =
            new Command("View.ShowSequenceVariableWindow", MessageResource.Command_View_ShowSequenceVariableWindow_Name)
            {
#if false
                Text = MessageResource.Command_View_ShowSequenceVariableWindow_Text,
#endif
                Image = ImageResource.BitmapIconSeqVariableWindow.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// エフェクトを表示。
        /// </summary>
        public static readonly Command ShowEffectWindow =
            new Command("View.ShowEffectWindow", MessageResource.Command_View_ShowEffectWindow_Name)
            {
#if false
                Text = MessageResource.Command_View_ShowEffectWindow_Text,
#endif
                Image = ImageResource.BitmapIconEffectWindow.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// インゲーム編集を表示。
        /// </summary>
        public static readonly Command ShowInGameWindow =
            new Command("View.ShowInGameWindow", MessageResource.Command_View_ShowInGameWindow_Name)
            {
                Image = ImageResource.BitmapIconInGameWindow.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// ブックマークを表示。
        /// </summary>
        public static readonly Command ShowBookmarkTreeWindow =
            new Command("View.ShowBookmarkTreeWindow", MessageResource.Command_View_ShowBookmarkTreeWindow_Name)
            {
#if false
                Text = MessageResource.Command_View_ShowBookmarkWindow_Text,
#endif
                Image = ImageResource.BitmapIconBookmarkTreeWindow.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// 履歴を表示。
        /// </summary>
        public static readonly Command ShowHistoryWindow =
            new Command("View.ShowHistoryWindow", MessageResource.Command_View_ShowHistroyWindow_Name)
            {
#if false
                Text = MessageResource.Command_View_ShowHistoryWindow_Text,
#endif
                Image = ImageResource.BitmapIconHistoryWindow.MakeNewTransparent(UIServiceBase.TransparentColor),
            };
    }
}
