﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Commands
{
    using System.Collections.Generic;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Reflection;
    using NintendoWare.SoundMaker.Framework.Resources;

    public static class ProjectTreeCommands
    {
        /// <summary>
        /// パーカッションリスト関連コマンドを列挙する IEnumerable を取得します。
        /// </summary>
        public static IEnumerable<Command> Commands
        {
            get
            {
                return ObjectFinder.FindStaticValues<Command>(typeof(ProjectTreeCommands),
                                                               BindingFlags.GetProperty | BindingFlags.GetField);
            }
        }

        /// <summary>
        /// 名前の変更。
        /// </summary>
        public static readonly Command Rename =
            new Command("ProjectTree.Rename", MessageResource.Command_ProjectTree_Rename_Name)
            {
#if false
                Text = MessageResource.Command_ProjectTree_Rename_Text,
#endif
            };

        /// <summary>
        /// 空のノードを隠す。
        /// </summary>
        public static readonly Command HideEmptyNode =
            new Command("ProjectTree.HideEmptyNode", MessageResource.Command_ProjectTree_HideEmptyNode_Name)
            {
#if false
                Text = MessageResource.Command_ProjectTree_HideEmptyNode_Text,
#endif
            };

        /// <summary>
        /// すべて空のノードを隠す。
        /// </summary>
        public static readonly Command AllHideEmptyNode =
            new Command("ProjectTree.AllHideEmptyNode", MessageResource.Command_ProjectTree_AllHideEmptyNode_Name)
            {
#if false
                Text = MessageResource.Command_ProjectTree_AllHideEmptyNode_Text,
#endif
            };

        /// <summary>
        /// すべて折りたたむ。
        /// </summary>
        public static readonly Command CollapseAll =
            new Command("ProjectTree.CollapseAll", string.Empty);

        /// <summary>
        /// サウンドアーカイブの出力設定
        /// </summary>
        public static readonly Command OutputType = new Command("ProjectTree.OutputType", string.Empty);


        public static readonly Command AddNewFolder =
            new Command("ProjectTree.AddNewFolder", MessageResource.Command_ProjectTree_AddNewFolder_Name);
    }
}
