﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Windows.Forms;
using NintendoWare.SoundMaker.Preview;
using NW4R.ProtocolSound;

namespace NintendoWare.SoundMaker.Windows.Forms
{
    public partial class EffectReverbStdPrameterControl : EffectParameterControl
    {
        public EffectReverbStdPrameterControl()
        {
            InitializeComponent();

            // パラメータを初期化する
            // Fused Mode
            _fusedModeCombo.Items.AddRange(new object[] {
                                            new FusedModeItem( ToolSoundFusedMode.FusedMode_OldAxfx,
                                                               Resources.MessageResource.Label_EffectFusedMode_OldAxfx ),
                                            new FusedModeItem( ToolSoundFusedMode.FusedMode_MetalTank,
                                                               Resources.MessageResource.Label_EffectFusedMode_MetalTank ),
                                            new FusedModeItem( ToolSoundFusedMode.FusedMode_SmallRoom,
                                                               Resources.MessageResource.Label_EffectFusedMode_SmallRoom ),
                                            new FusedModeItem( ToolSoundFusedMode.FusedMode_LargeRoom,
                                                               Resources.MessageResource.Label_EffectFusedMode_LargeRoom ),
                                            new FusedModeItem( ToolSoundFusedMode.FusedMode_Hall,
                                                               Resources.MessageResource.Label_EffectFusedMode_Hall ),
                                            new FusedModeItem( ToolSoundFusedMode.FusedMode_Cavernous,
                                                               Resources.MessageResource.Label_EffectFusedMode_Cavernous ) });
            _fusedModeCombo.SelectedIndex = 0;

            // PreDelayTime
            _preDelayTimeEdit.Maximum = _preDelayTimeMaxEdit.Value;
        }

        #region ** プロパティ

        /// <summary>
        /// 関連付けられたパラメータを取得します。
        /// </summary>
        private new ReverbStdParameter Parameter
        {
            get
            {
                Debug.Assert(base.Parameter is ReverbStdParameter);
                return base.Parameter as ReverbStdParameter;
            }
        }

        #endregion

        #region ** イベントハンドラ

        private void OnEarlyModeValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.EarlyMode = decimal.ToInt32(target.Value);
        }

        private void OnPreDelayTimeMaxValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.PreDelayTimeMax = (float)target.Value;
        }

        private void OnPreDelayTimeValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.PreDelayTime = (float)target.Value;
        }

        private void OnFusedModeSelectionChangeCommitted(object sender, EventArgs e)
        {
            ComboBox target = sender as ComboBox;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.FusedMode = (ToolSoundFusedMode)target.SelectedIndex;
        }

        private void OnFusedTimeValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.FusedTime = (float)target.Value;
        }

        private void OnColorationValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.Coloration = (float)target.Value;
        }

        private void OnDampingValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.Damping = (float)target.Value;
        }

        private void OnEarlyGainValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.EarlyGain = (float)target.Value;
        }

        private void OnFusedGainValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.FusedGain = (float)target.Value;
        }

        private void OnOutGainValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.OutGain = (float)target.Value;
        }

        #endregion

        #region ** イベントハンドラのオーバーライド

        public override void OnParameterChanged(object sender, EventArgs e)
        {
            decimal preDelayTimeMax = Convert.ToDecimal(Parameter.PreDelayTimeMax);
            if (_preDelayTimeEdit.Value > preDelayTimeMax)
            {
                _preDelayTimeEdit.Value = preDelayTimeMax;
            }

            _earlyModeEdit.Value = Parameter.EarlyMode;
            _preDelayTimeMaxEdit.Value = preDelayTimeMax;
            _preDelayTimeEdit.Maximum = preDelayTimeMax;
            _preDelayTimeEdit.Value = Convert.ToDecimal(Parameter.PreDelayTime);
            _fusedModeCombo.SelectedIndex = (int)Parameter.FusedMode;
            _fusedTimeEdit.Value = Convert.ToDecimal(Parameter.FusedTime);
            _colorationEdit.Value = Convert.ToDecimal(Parameter.Coloration);
            _dampingEdit.Value = Convert.ToDecimal(Parameter.Damping);
            _earlyGainEdit.Value = Convert.ToDecimal(Parameter.EarlyGain);
            _fusedGainEdit.Value = Convert.ToDecimal(Parameter.FusedGain);
            _outGainEdit.Value = Convert.ToDecimal(Parameter.OutGain);

            base.OnParameterChanged(sender, e);
        }

        #endregion
    }
}
