﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundMaker.Windows.Forms
{
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Preview;
    using NW4R.ProtocolSound;

    public partial class EffectMultiChannelReverbParameterControl : EffectParameterControl
    {
        public EffectMultiChannelReverbParameterControl()
        {
            InitializeComponent();

            // パラメータを初期化する
            // Early Mode
            comboBox_EarlyMode.Items.AddRange(new object[] {
                new EarlyModeItem( ToolSoundEarlyMode.SmallRoom,
                                   Resources.MessageResource.Label_EffectEarlyMode_SmallRoom ),
                    new EarlyModeItem( ToolSoundEarlyMode.LargeRoom,
                                       Resources.MessageResource.Label_EffectEarlyMode_LargeRoom ),
                    new EarlyModeItem( ToolSoundEarlyMode.Hall,
                                       Resources.MessageResource.Label_EffectEarlyMode_Hall ),
                    new EarlyModeItem( ToolSoundEarlyMode.Cavern,
                                       Resources.MessageResource.Label_EffectEarlyMode_Cavern ),
                    new EarlyModeItem( ToolSoundEarlyMode.None,
                                       Resources.MessageResource.Label_EffectEarlyMode_None ) });

            comboBox_EarlyMode.SelectedIndex = 0;

            // Late Mode
            comboBox_LateMode.Items.AddRange(new object[] {
                new LateModeItem( ToolSoundLateMode.Room,
                                  Resources.MessageResource.Label_EffectLateMode_Room ),
                    new LateModeItem( ToolSoundLateMode.Hall,
                                      Resources.MessageResource.Label_EffectLateMode_Hall ),
                    new LateModeItem( ToolSoundLateMode.MetalCorridor,
                                      Resources.MessageResource.Label_EffectLateMode_MetalCorridor ),
                    new LateModeItem( ToolSoundLateMode.Cavern,
                                      Resources.MessageResource.Label_EffectLateMode_Cavern ),
                    new LateModeItem( ToolSoundLateMode.Maximun,
                                      Resources.MessageResource.Label_EffectLateMode_Maximun ) });

            comboBox_LateMode.SelectedIndex = 0;
        }

        #region ** プロパティ

        /// <summary>
        /// 関連付けられたパラメータを取得します。
        /// </summary>
        private new MultiChannelReverbParameter Parameter
        {
            get
            {
                Debug.Assert(base.Parameter is MultiChannelReverbParameter);
                return base.Parameter as MultiChannelReverbParameter;
            }
        }

        #endregion


        #region ** イベントハンドラ

        private void OnEarlyModeValueChanged(object sender, EventArgs e)
        {
            ComboBox target = sender as ComboBox;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.EarlyMode = (ToolSoundEarlyMode)target.SelectedIndex;
        }

        private void OnLateModeValueChanged(object sender, EventArgs e)
        {
            ComboBox target = sender as ComboBox;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.LateMode = (ToolSoundLateMode)target.SelectedIndex;
        }

        private void OnPreDelayTimeValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.PreDelayTime = (float)target.Value;
        }

        private void OnDecayTimeValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.DecayTime = (float)target.Value;
        }

        private void OnHfDecayRatioValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.HfDecayRatio = (float)target.Value;
        }

        private void OnColorationValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.Coloration = (float)target.Value;
        }

        private void OnEarlyGainValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.EarlyGain = (float)target.Value;
        }

        private void OnLateGainValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.LateGain = (float)target.Value;
        }

        private void OnReverbGainValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.ReverbGain = (float)target.Value;
        }

        #endregion

        #region ** イベントハンドラのオーバーライド

        public override void OnParameterChanged(object sender, EventArgs e)
        {
            comboBox_EarlyMode.SelectedIndex = (int)Parameter.EarlyMode;
            comboBox_LateMode.SelectedIndex = (int)Parameter.LateMode;
            numericEdit_PreDelayTime.Value = Convert.ToDecimal(Parameter.PreDelayTime);
            numericEdit_DecayTime.Value = Convert.ToDecimal(Parameter.DecayTime);
            numericEdit_HfDecayRatio.Value = Convert.ToDecimal(Parameter.HfDecayRatio);
            numericEdit_Coloration.Value = Convert.ToDecimal(Parameter.Coloration);
            numericEdit_EarlyGain.Value = Convert.ToDecimal(Parameter.EarlyGain);
            numericEdit_LateGain.Value = Convert.ToDecimal(Parameter.LateGain);
            numericEdit_ReverbGain.Value = Convert.ToDecimal(Parameter.ReverbGain);

            base.OnParameterChanged(sender, e);
        }

        #endregion

    }

    public class EarlyModeItem
    {
        private ToolSoundEarlyMode _earlyMode = ToolSoundEarlyMode.SmallRoom;
        private string _text = "";

        public EarlyModeItem(ToolSoundEarlyMode earlyMode, string text)
        {
            _earlyMode = earlyMode;
            _text = text;
        }

        #region ** プロパティ

        public ToolSoundEarlyMode EarlyMode
        {
            get { return _earlyMode; }
        }

        #endregion

        #region ** メソッドのオーバーライド

        public override string ToString()
        {
            return _text;
        }

        #endregion
    }

    public class LateModeItem
    {
        private ToolSoundLateMode _lateMode = ToolSoundLateMode.Room;
        private string _text = "";

        public LateModeItem(ToolSoundLateMode lateMode, string text)
        {
            _lateMode = lateMode;
            _text = text;
        }

        #region ** プロパティ

        public ToolSoundLateMode LateMode
        {
            get { return _lateMode; }
        }

        #endregion

        #region ** メソッドのオーバーライド

        public override string ToString()
        {
            return _text;
        }

        #endregion
    }
}
