﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Windows.Forms;
using NintendoWare.SoundMaker.Preview;
using NW4R.ProtocolSound;

namespace NintendoWare.SoundMaker.Windows.Forms
{
    public partial class EffectDelayPrameterControl : EffectParameterControl
    {
        public EffectDelayPrameterControl()
        {
            InitializeComponent();

            // パラメータを初期化する
            // DelayTime
            _delayTimeEdit.Maximum = _maxDelayTimeEdit.Value;
        }

        #region ** プロパティ

        /// <summary>
        /// 関連付けられたパラメータを取得します。
        /// </summary>
        private new DelayParameter Parameter
        {
            get
            {
                Debug.Assert(base.Parameter is DelayParameter);
                return base.Parameter as DelayParameter;
            }
        }

        #endregion

        #region ** イベントハンドラ

        private void OnMaxDelayTimeValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.MaxDelayTime = (float)target.Value;
        }

        private void OnDelayTimeValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.DelayTime = (float)target.Value;
        }

        private void OnFeedbackValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.Feedback = (float)target.Value;
        }

        private void OnOutGainValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.OutGain = (float)target.Value;
        }

        private void OnLPFValueChanged(object sender, ValueChangedEventArgs e)
        {
            NumericEdit target = sender as NumericEdit;
            Debug.Assert(null != target);

            // パラメータとの同期
            Parameter.LPF = (float)target.Value;
        }

        #endregion

        #region ** イベントハンドラのオーバーライド

        public override void OnParameterChanged(object sender, EventArgs e)
        {
            decimal maxDelayTime = Convert.ToDecimal(Parameter.MaxDelayTime);
            if (_delayTimeEdit.Value > maxDelayTime)
            {
                _delayTimeEdit.Value = maxDelayTime;
            }

            _maxDelayTimeEdit.Value = maxDelayTime;
            _delayTimeEdit.Maximum = maxDelayTime;
            _delayTimeEdit.Value = Convert.ToDecimal(Parameter.DelayTime);
            _feedbackEdit.Value = Convert.ToDecimal(Parameter.Feedback);
            _outGainEdit.Value = Convert.ToDecimal(Parameter.OutGain);
            _lpfEdit.Value = Convert.ToDecimal(Parameter.LPF);

            base.OnParameterChanged(sender, e);
        }

        #endregion
    }
}
