﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;

namespace NintendoWare.SoundMaker.Preview
{
    public class PreviewPlayerInformation
    {
        #region ** デリゲート

        private delegate void UpdateStateHandler();

        #endregion

        private PreviewPlayer _target = null;
        private PreviewSound _sound = null;
        private PreviewPlayerState _state = PreviewPlayerState.Disabled;
        private PreviewPlayerState _nextState = PreviewPlayerState.Disabled;
        private object _soundLock = new object();
        private object _stateLock = new object();

        public PreviewPlayerInformation(PreviewPlayer target, PreviewPlayerState initStateType)
        {
            _target = target;
            _state = initStateType;
            _nextState = initStateType;
        }

        #region ** プロパティ

        public PreviewPlayer PreviewPlayer
        {
            get { return _target; }
        }

        public PreviewSound Sound
        {
            get
            {
                lock (_soundLock)
                {
                    return _sound;
                }
            }
            set
            {
                lock (_soundLock)
                {
                    _sound = value;
                }
            }
        }

        public PreviewPlayerState State
        {
            get
            {
                lock (_stateLock)
                {

                    if (_state != _nextState)
                    {
                        UpdateState();
                    }

                    return _state;

                }
            }
            set
            {
                if (value == _nextState) { return; }

                if (null == PreviewManager.Instance.InvokeControl)
                {
                    OnUpdateState();
                    return;
                }

                _nextState = value;
                PreviewManager.Instance.InvokeControl.BeginInvoke(new UpdateStateHandler(OnUpdateState));
            }
        }

        #endregion

        #region ** イベント

        public event EventHandler StateChanged;

        #endregion

        #region ** イベントハンドラ

        protected virtual void OnStateChanged(EventArgs e)
        {
            if (null != StateChanged)
            {
                StateChanged(this, e);
            }
        }

        private void OnUpdateState()
        {
            lock (_stateLock)
            {

                if (_nextState == _state) { return; }

                _state = _nextState;

                OnStateChanged(new EventArgs());

            }
        }

        #endregion

        #region ** メソッド

        public void UpdateState()
        {
            if (null != PreviewManager.Instance.InvokeControl &&
                PreviewManager.Instance.InvokeControl.InvokeRequired) { return; }

            OnUpdateState();
        }

        #endregion
    }

    #region ** コレクションクラス

    public class PreviewPlayerInformationCollectionCommon : KeyedCollection<uint, PreviewPlayerInformation>
    {
        /// <summary>
        /// 指定した要素からキーを抽出します。
        /// </summary>
        /// <param name="item">キーの抽出元要素。</param>
        /// <returns>指定した要素のキー。</returns>
        protected override uint GetKeyForItem(PreviewPlayerInformation item)
        {
            if (null == item.PreviewPlayer) { throw new Exception("unexpected error"); }
            return item.PreviewPlayer.Index;
        }
    }

    #endregion
}
