﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

// タイムアウトを利用した読み込み待ちを行うかどうか
//#define USE_TIMEOUT

using System;
using System.Diagnostics;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace NintendoWare.Generic.Preview.MCS.Viewer
{
    using NintendoWare.SoundMaker.Framework.Preview.Communications;
    using NintendoWare.SoundMaker.Framework.Preview.Communications.Tool;
    using NintendoWare.SoundMaker.Framework.Preview.Communications.Viewer;

    /// <summary>
    /// ビューア接続
    /// <para>
    /// ビューアからツールに送られるパケットを処理する接続です。
    /// </para>
    /// </summary>
    public class MCSViewerConnection : MCSConnection
    {
        // 読み込み間隔
        private const int interval = 100;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public MCSViewerConnection() { }

        /// <summary>
        /// チャンネルの取得。
        /// </summary>
        public override uint Channel
        {
#if ANIMATION
            get{ return _baseChannel + 0x3; }
#else
            get { return _baseChannel + 0x1; }
#endif
        }

#if USE_TIMEOUT
        /// <summary>
        /// 接続
        /// </summary>
        public override bool Connect(IPEndPoint ipEndPoint, string hostName)
        {
            bool result = base.Connect(ipEndPoint, hostName);
            if(result)
            {
                Client.ReceiveTimeout = interval;
                Client.SendTimeout = interval;
            }
            return result;
        }
#endif

        //---------------------------------------------------------------------
        /// <summary>
        /// メインループ。
        /// </summary>
        public override void MainLoop()
        {
#if USE_TIMEOUT
            // タイムアウトを利用した読み込み待ち
            MCSPacketHeader header = null;
            try
            {
                header = new MCSPacketHeader(Reader);
                Debug.Assert(!header.Error);
            }
            catch(IOException exception)
            {
                Exception inner = exception.InnerException;
                if((inner != null) && (inner is SocketException)){ return; }
                throw exception;
            }
#else
            // ネットワークストリームのDataAvailableを利用した読み込み待ち
            if (!((NetworkStream)Reader.BaseStream).DataAvailable)
            {
                Thread.Sleep(interval);
                return;
            }
            CommPacketHeader header = new CommPacketHeader(Reader);
            Debug.Assert(!header.Error);
#endif

            ViewerPacket packet = ViewerPacket.Create(header);
            packet.Read(Reader, header);
            //ShowMessage( "  Viewer ← " + packet );
            if (packet.Reply)
            {
                CommPacketHeader replyHeader = packet.Write(Writer);
                Writer.Flush();
                //ShowMessage( "       → " + replyHeader );
            }
        }

    }
}
