﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Preview.Configurations
{
    using NintendoWare.SoundMaker.Configurations.Schemas;
    using NW4R.ProtocolSound;

    public class MultiChannelDelayConverter : EffectConverter<XmlMultiChannelDelay, MultiChannelDelayParameter>
    {
        protected override void ApplyParameters(XmlMultiChannelDelay xmlEffect, MultiChannelDelayParameter effectParameter)
        {
            effectParameter.Delay = xmlEffect.Delay;
            effectParameter.Feedback = xmlEffect.Feedback;
            effectParameter.OutGain = xmlEffect.OutGain;
            effectParameter.ChannelSpread = xmlEffect.ChannelSpread;
            effectParameter.LPF = xmlEffect.LPF;
        }

        protected override void ExtractParameters(MultiChannelDelayParameter effectParameter, XmlMultiChannelDelay xmlEffect)
        {
            xmlEffect.Delay = effectParameter.Delay;
            xmlEffect.Feedback = effectParameter.Feedback;
            xmlEffect.OutGain = effectParameter.OutGain;
            xmlEffect.ChannelSpread = effectParameter.ChannelSpread;
            xmlEffect.LPF = effectParameter.LPF;
        }
    }
}
